% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{charlson_rcs}
\alias{charlson_rcs}
\title{Charlson Comorbidities (Royal College of Surgeons)}
\format{
An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 121 rows and 2 columns.
}
\source{
\doi{10.1002/bjs.6930}
}
\usage{
charlson_rcs
}
\description{
Specification of the Charlson comorbidity index
in the version of the Royal College of Surgeons (2010).
}
\details{
The specification can be expanded using the \link{icd_expand}
function to return all corresponding ICD-10-GM codes.

This table was created on the basis of the publication
referenced below. It is provided as is with no guarantee
of accuracy. Furthermore, the applicability of the codes
in the context of the German ICD-10-GM is unclear.

\describe{
\item{Condition}{Disease entity}
\item{ICD_SPEC}{Secification of the corresponding ICD-10 codes, suitable for input to \link{icd_expand}}
}
}
\seealso{
Other Charlson: 
\code{\link{charlson_sundararajan}}
}
\concept{Charlson}
\keyword{datasets}
