% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeriTools.R
\name{fitComputeVPC.lmer}
\alias{fitComputeVPC.lmer}
\title{Fit linear mixed models (LMM) and compute the VPC values for one or more 
features.}
\usage{
fitComputeVPC.lmer(CountMatrix, Strains, PriorWeights = NULL, test = FALSE,
  VPCname = "LMM")
}
\arguments{
\item{CountMatrix}{Sequencing count matrix for one or more features. Each 
row is for one feature, and the columns are for samples.}

\item{Strains}{Strain labels for the samples.}

\item{PriorWeights}{Weights used in the lmer function in the package lme4. 
It is an optional vector used in the fitting process.}

\item{test}{TRUE or FALSE (default). Test the presence of heritability 
through examining the random effect variance \eqn{\sigma_g^2 = 0}{}.}

\item{VPCname}{Name of the VPC result, default = "LMM".}
}
\value{
A list with two objects. The first object is a 
\eqn{1 \times G}{1 x G} vector indicating the variance partition coefficients
(VPC). If the argument test is set to be true, the second object of 
the list consists of p-values for testing the hypothesis that random 
effects \eqn{\sigma_a^2 = 0}{sigma_a2 = 0}; otherwise, the second 
object is NULL.
}
\description{
Fit the Gaussian-like data to LMM and compute the VPC values for 
one or more features.
}
\examples{
## Compute VPC for the first two features under linear mixed models for Gaussian-like datasets. 

## Provide normalized data and include hypothesis testing on presence of
## heritability:
result.vst <- fitComputeVPC.lmer(simData_vst[1:2,], strains, test = TRUE)
## Extract parameters
vpc.vst <- result.vst[[1]]
## Extract p-values
pval.vst <- result.vst[[2]]

## Visulize the distribution of p-values.
hist(pval.vst, breaks = 30, col = "cyan")
}

