% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Util.R
\name{phyloseq2table}
\alias{phyloseq2table}
\title{Phyloseq conversion to a ggplot-formatted table}
\usage{
phyloseq2table(physeq, include_sample_data = FALSE, sample_col_keep = NULL,
  include_tax_table = FALSE, tax_col_keep = NULL, control_expr = NULL)
}
\arguments{
\item{physeq}{Phyloseq object}

\item{include_sample_data}{Include \code{sample_table} information?}

\item{sample_col_keep}{Which columns in the \code{sample_data} table to keep?
Use \code{NULL} to keep all columns.}

\item{include_tax_table}{Include \code{tax_table} information?}

\item{tax_col_keep}{A vector for column names to keep.
Use \code{NULL} to keep all columns.}

\item{control_expr}{An expression for identifying which samples are controls.
Control/non-control identification will be in the 'IS_CONTROL' column of the
returned data.frame object.}
}
\value{
data.frame
}
\description{
Convert the OTU table (+ metadata) to a format that can be
easily plotted with phyloseq
}
\examples{
data(physeq_S2D1)
# Including some columns from sample metadata
df_OTU = phyloseq2table(physeq_S2D1,
                        include_sample_data=TRUE,
                        sample_col_keep=c('Buoyant_density', 'Substrate', 'Day'))
head(df_OTU)

# Including some columns from sample metadata & taxonomy
df_OTU = phyloseq2table(physeq_S2D1,
                        include_sample_data=TRUE,
                        sample_col_keep=c('Buoyant_density', 'Substrate', 'Day'),
                        include_tax_table=TRUE)
head(df_OTU)

}

