/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.ImageObserver;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;

public class EPSGraphics
extends Graphics {
    private Color _currentColor = Color.black;
    private Font _currentFont;
    private int _width;
    private int _height;
    private Hashtable _linepattern = new Hashtable();
    private OutputStream _out;
    private StringBuffer _buffer = new StringBuffer();
    private Clipboard _clipboard;
    private static String[] _patterns = new String[]{"[]", "[1 1]", "[4 4]", "[4 4 1 4]", "[2 2]", "[4 2 1 2 1 2]", "[5 3 2 3]", "[3 3]", "[4 2 1 2 2 2]", "[1 2 5 2 1 2 1 2]", "[4 1 2 1]"};
    private int _patternIndex = 0;

    public EPSGraphics(OutputStream outputStream, int n, int n2) {
        this._width = n;
        this._height = n2;
        this._out = outputStream;
        this._buffer.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        this._buffer.append("%%Creator: UC Berkeley Plot Package\n");
        this._buffer.append("%%BoundingBox: 50 50 " + (50 + n) + " " + (50 + n2) + "\n");
        this._buffer.append("%%Pages: 1\n");
        this._buffer.append("%%Page: 1 1\n");
        this._buffer.append("%%LanguageLevel: 2\n");
    }

    public void clearRect(int n, int n2, int n3, int n4) {
    }

    public void clipRect(int n, int n2, int n3, int n4) {
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public Graphics create() {
        return new EPSGraphics(this._out, this._width, this._height);
    }

    public void dispose() {
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return true;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Point point = this._convert(n, n2);
        Point point2 = this._convert(n3, n4);
        this._buffer.append("newpath " + point.x + " " + point.y + " moveto\n");
        this._buffer.append("" + point2.x + " " + point2.y + " lineto\n");
        this._buffer.append("stroke\n");
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if (!this._polygon(nArray, nArray2, n)) {
            return;
        }
        this._buffer.append("closepath stroke\n");
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        int n5 = n3 / 2;
        Point point = this._convert(n + n5, n2 + n5);
        this._buffer.append("newpath " + point.x + " " + point.y + " " + n5 + " 0 360 arc closepath stroke\n");
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        Point point = this._convert(n, n2);
        this._buffer.append("newpath " + point.x + " " + point.y + " moveto\n");
        this._buffer.append("0 " + -n4 + " rlineto\n");
        this._buffer.append("" + n3 + " 0 rlineto\n");
        this._buffer.append("0 " + n4 + " rlineto\n");
        this._buffer.append("" + -n3 + " 0 rlineto\n");
        this._buffer.append("closepath stroke\n");
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        throw new RuntimeException("Sorry, drawString(java.text.AttributedCharacterIterator, int , int) is not implemented in EPSGraphics");
    }

    public void drawString(String string, int n, int n2) {
        Point point = this._convert(n, n2);
        this._buffer.append("" + point.x + " " + point.y + " moveto\n");
        this._buffer.append("(" + string + ") show\n");
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if (!this._polygon(nArray, nArray2, n)) {
            return;
        }
        this._buffer.append("closepath fill\n");
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        int n5 = n3 / 2;
        Point point = this._convert(n + n5, n2 + n5);
        this._buffer.append("newpath " + point.x + " " + point.y + " " + n5 + " 0 360 arc closepath fill\n");
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        Point point = this._convert(n, n2);
        this._fillPattern();
        this._buffer.append("newpath " + point.x + " " + point.y + " moveto\n");
        this._buffer.append("0 " + -n4 + " rlineto\n");
        this._buffer.append("" + n3 + " 0 rlineto\n");
        this._buffer.append("0 " + n4 + " rlineto\n");
        this._buffer.append("" + -n3 + " 0 rlineto\n");
        this._buffer.append("closepath gsave fill grestore\n");
        this._buffer.append("0.5 setlinewidth 0 setgray [] 0 setdash stroke\n");
        this._buffer.append("1 setlinewidth\n");
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public Color getColor() {
        return this._currentColor;
    }

    public Font getFont() {
        return this._currentFont;
    }

    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        int n = font.getSize();
        boolean bl = font.isBold();
        if (bl) {
            this._buffer.append("/Helvetica-Bold findfont\n");
        } else {
            this._buffer.append("/Helvetica findfont\n");
        }
        this._buffer.append("" + n + " scalefont setfont\n");
        this._currentFont = font;
    }

    public void setClip(Shape shape) {
    }

    public void setClip(int n, int n2, int n3, int n4) {
    }

    public void setColor(Color color) {
        if (color == Color.black) {
            this._buffer.append("0 setgray\n");
            this._buffer.append("[] 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
        } else if (color == Color.white) {
            this._buffer.append("1 setgray\n");
            this._buffer.append("[] 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
        } else if (color == Color.lightGray) {
            this._buffer.append("0.9 setgray\n");
            this._buffer.append("[] 0 setdash\n");
            this._buffer.append("0.5 setlinewidth\n");
        } else if (this._linepattern.containsKey(color)) {
            this._buffer.append((String)this._linepattern.get(color) + " 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
        } else {
            this._buffer.append("0 setgray\n");
            if (this._patternIndex >= _patterns.length) {
                this._patternIndex = 0;
            }
            this._buffer.append(_patterns[this._patternIndex] + " 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
            this._linepattern.put(color, _patterns[this._patternIndex]);
            ++this._patternIndex;
        }
        this._currentColor = color;
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public void showpage() {
        this._buffer.append("showpage\n");
        if (this._out != null) {
            PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(this._out));
            printWriter.println(this._buffer.toString());
            printWriter.flush();
        } else {
            if (this._clipboard == null) {
                this._clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            StringSelection stringSelection = new StringSelection(this._buffer.toString());
            this._clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public void translate(int n, int n2) {
    }

    private Point _convert(int n, int n2) {
        return new Point(n + 50, this._height + 50 - n2);
    }

    private boolean _polygon(int[] nArray, int[] nArray2, int n) {
        if (n < 3 || nArray.length < n || nArray2.length < n) {
            return false;
        }
        Point point = this._convert(nArray[0], nArray2[0]);
        this._buffer.append("newpath " + point.x + " " + point.y + " moveto\n");
        for (int i = 1; i < n; ++i) {
            Point point2 = this._convert(nArray[i], nArray2[i]);
            this._buffer.append("" + point2.x + " " + point2.y + " lineto\n");
        }
        return true;
    }

    private void _fillPattern() {
        int n = this._currentColor.getRed();
        int n2 = this._currentColor.getGreen();
        int n3 = this._currentColor.getBlue();
        double d = 0.6;
        double d2 = 0.8;
        double d3 = 1.0;
        double d4 = Math.sqrt(65025.0 * (d * d + d2 * d2 + d3 * d3));
        double d5 = Math.sqrt((double)(n * n) * d2 * d2 + (double)(n3 * n3) * d * d + (double)(n2 * n2) * d3 * d3) / d4;
        this._buffer.append("" + d5 + " setgray\n");
        this._buffer.append("%---- rgb: " + n + " " + n2 + " " + n3 + "\n");
    }
}

