% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{hrm.test}
\alias{hrm.test}
\title{Test for no main treatment effect, no main time effect, no simple treatment effect and no interaction between treatment and time}
\usage{
hrm.test(n, a, d, X, alpha)
}
\arguments{
\item{n}{an vector containing the sample sizes of all groups}

\item{a}{number of groups}

\item{d}{number of dimensions (time points)}

\item{X}{list containing the data matrices of all groups}

\item{alpha}{alpha level used for the test}
}
\value{
Returns a data frame consisting of the degrees of freedom, the test value, the critical value and the p-value
}
\description{
Test for no main treatment effect, no main time effect, no simple treatment effect and no interaction between treatment and time
}
\examples{
# number patients per group
n = c(10,10)
# number of groups
a=2
# number of variables
d=40

# defining the list consisting of the samples from each group
mu_1 = mu_2 = rep(0,d)
# autoregressive covariance matrix
sigma_1 = diag(d)
for(k in 1:d) for(l in 1:d) sigma_1[k,l] = 1/(1-0.5^2)*0.5^(abs(k-l))
sigma_2 = 1.5*sigma_1
X = list(mvrnorm(n[1],mu_1, sigma_1), mvrnorm(n[2],mu_2, sigma_2))

# test for the main treatment effect and print the p.value
hrm.test(n, a, d, X, 0.05)
}

