\name{generateTree}
\alias{generateTree}
\title{Generate Test Trees}
\description{This function will take several initial trees and will randomly populate X new trees based on the originals.}
\usage{
generateTree(data = NULL, nreads = 7000, nsamps = 200, theta = 0)
}

\arguments{
  \item{data}{A data set that contains 1 column containing the taxa levels and at least 1 column of values for those levels.}
  \item{nreads}{The maximum number of reads the created a tree will contain.}
  \item{nsamps}{The number of trees to generate.}
  \item{theta}{When theta is between 0 and 1 the base tree is generated by using the \code{dirmult} function and modified by 
  	the theta value, otherwise the base tree is generated by the \code{DM.MoM} function.}
}

\details{This functions requires that the package \code{HMP} be installed.}

\value{A data frame containing the generated tree(s).}
\author{Patricio S. La Rosa, Elena Deych, Berkley Shands, William D. Shannon}

\examples{
data(saliva)

gendata <- generateTree(saliva, 7000, 2)
}