% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{build.descendants}
\alias{build.descendants}
\alias{build.descendants.per.level}
\alias{build.descendants.bottom.up}
\title{Build descendants}
\usage{
build.descendants(g)

build.descendants.per.level(g, levels)

build.descendants.bottom.up(g, levels)
}
\arguments{
\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{levels}{a list of character vectors. Each component represents a graph level and the elements of any component correspond to nodes.
The level 0 coincides with the root node.}
}
\value{
\code{build.descendants} returns a named list of vectors. Each component corresponds to a node \eqn{x} of the graph, and its vector
is the set of its descendants including also \eqn{x}.

\code{build.descendants.per.level} returns a named list of vectors.
Each component corresponds to a node \eqn{x} of the graph and its vector is the set of its descendants including also \eqn{x}.
The nodes are ordered from root (included) to leaves.

\code{build.descendants.bottom.up} returns a named list of vectors. Each component corresponds to a node \eqn{x} of
the graph and its vector is the set of its descendants including also \eqn{x}. The nodes are ordered from leaves to root (included).
}
\description{
Build descendants for each node of a graph.
}
\examples{
data(graph);
root <- root.node(g);
desc <- build.descendants(g);
lev <- graph.levels(g, root=root);
desc.tod <- build.descendants.per.level(g,lev);
desc.bup <- build.descendants.bottom.up(g,lev);
}
