% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{ancestors}
\alias{ancestors}
\alias{build.ancestors}
\alias{build.ancestors.per.level}
\alias{build.ancestors.bottom.up}
\title{Build ancestors}
\usage{
build.ancestors(g)

build.ancestors.per.level(g, levels)

build.ancestors.bottom.up(g, levels)
}
\arguments{
\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{levels}{a list of character vectors. Each component represents a graph level and the elements of any 
component correspond to nodes. The level 0 coincides with the root node.}
}
\value{
\code{build.ancestos} returns a named list of vectors. Each component corresponds to a node \eqn{x} of the graph and its vector 
is the set of its ancestors including also \eqn{x}.

\code{build.ancestors.per.level} returns a named list of vectors. Each component corresponds to a node \eqn{x} 
of the graph and its vector is the set of its ancestors including also \eqn{x}. The nodes are ordered from root (included) to leaves.

\code{build.ancestors.bottom.up} a named list of vectors. Each component corresponds to a node \eqn{x} of the 
graph and its vector is the set of its ancestors including also \eqn{x}. The nodes are ordered from leaves to root (included).
}
\description{
Compute the ancestors for each node of a graph.
}
\examples{
data(graph);
root <- root.node(g);
anc <- build.ancestors(g);
lev <- graph.levels(g, root=root);
anc.tod <-build.ancestors.per.level(g,lev);
anc.bup <- build.ancestors.bottom.up(g,lev);
}
\seealso{
\code{\link{graph.levels}}
}
