% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_summary.R
\name{summary.ResScanOutputMulti}
\alias{summary.ResScanOutputMulti}
\title{Summary of the clusters obtained with a multivariate scan function (MG or MNP).}
\usage{
\method{summary}{ResScanOutputMulti}(
  object,
  type_summ = "param",
  digits = 3,
  quantile.type = 7,
  only.MLC = FALSE,
  ...
)
}
\arguments{
\item{object}{ResScanOutputMulti. Output of a multivariate scan function (MG or MNP).}

\item{type_summ}{character. "param" or "nparam". "param" gives the mean and the sd for each variable in the clusters, outside, and globally and "nparam" gives the Q25, Q50 and Q75 quantiles for each variables in the clusters, outside, and globally.}

\item{digits}{integer. Number of decimals in output.}

\item{quantile.type}{An integer between 1 and 9 (see function quantile). Ignored if type_summ is "param"}

\item{only.MLC}{logical. Should we summarize only the MLC or all the significant clusters?}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
No value returned, displays the results in the console
}
\description{
This function gives a summary of the clusters in a table
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("multi_data")
coords <- coordinates(map_sites)
res_mg <- SpatialScan(method = "MG", data=multi_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2)$MG
summary(object = res_mg)}
\dontshow{
library(sp)
data("map_sites")
data("multi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_mg <- SpatialScan(method = "MG", data=multi_data[indices,],
sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 9)$MG
if(length(res_mg$sites_clusters)>0){
summary(object = res_mg)
}

}


}
