% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_uni.R
\name{UG}
\alias{UG}
\title{UG scan procedure}
\usage{
UG(data, MC = 999, typeI = 0.05, initialization, permutations)
}
\arguments{
\item{data}{vector. Vector of the data, each element corresponds to a site (or an individual if the observations are by individuals and not by sites).}

\item{MC}{numeric. Number of Monte-Carlo permutations to evaluate the statistical significance of the clusters. By default: 999.}

\item{typeI}{numeric. The desired type I error. A cluster will be evaluated as significant if its associated p-value is less than typeI. By default 0.05.}

\item{initialization}{list. Initialization for the scan procedure (see \code{\link{InitScan}} for more details).}

\item{permutations}{matrix. Indices of permutations of the data.}
}
\value{
An object of class ResScanOutputUni.
}
\description{
This function computes the UG (Univariate Gaussian scan statistic).
}
\references{
Martin Kulldorff and Lan Huang and Kevin Konty (2009). A Scan Statistic for Continuous Data Based on the Normal Probability Model. International Journal of Health Geographics, 8 (58).
}
