% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GpGp.R
\docType{package}
\name{GpGp}
\alias{GpGp}
\alias{GpGp-package}
\title{GpGp: Fast Gaussian Process Computing.}
\description{
Vecchia's (1988)
Gaussian process approximation has emerged among its competitors
as a leader in computational scalability and accuracy. This package includes
implementations of the original approximation, as well as several
updates to it, including the reordered and grouped versions of the 
approximation outlined in Guinness (2018).
}
\details{
The main functions of the package are \code{fit_model}, and \code{\link{predictions}}.
\code{fit_model} returns maximum likelihood estimates for covariance parameters
and linear mean parameters. The user is expected to store the response in a vector
\code{y} and the locations--either spatial or spatial-temporal--in a matrix \code{locs},
which contains in each row the spatial or spatial-temporal location of the 
corresponding response. The user is also expected to select a covariance function
and specify it with a string. Currently supported functions are \code{"matern_isotropic"}
for spatial data, \code{"matern_sphere"} for spatial data over the globe, and 
\code{"matern_sphere_time"} for spatial-temporal data over the globe. For the \code{sphere}
the coordinates should be expressed in longitudes and latitudes. If there are 
covariates, they can be expressed via a design matrix \code{X}, each row containing
the covariates corresponding to the same row in \code{locs}. 

For \code{\link{predictions}}, the user should specify prediction locations 
\code{locs_pred} and a prediction design matrix \code{X_pred}.

The vignettes are intended to be helpful for getting a sense of how 
these functions work. The windspeed
vignette can be a guide for spatial and spatial-temporal data over the globe.

For Gaussian process researchers, the package also provides access to likelihood
and profile likelihood functions, reordering functions, nearest neighbor-finding 
functions, grouping (partitioning) functions, and approximate simulation functions.
We think that there is potential for improving the grouping algorithms, and 
scope for improving the approximations by tailoring the choice of ordering 
and the grouping algorithm to suit one another.
}
