% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_plots.R
\name{sentiment_trend}
\alias{sentiment_trend}
\title{Plot sentiment trend over time}
\usage{
sentiment_trend(sentiment_df, time_period = "month", show_smooth_trend = FALSE)
}
\arguments{
\item{sentiment_df}{A data frame containing the output from analyze_sentiment.}

\item{time_period}{A string specifying the time period for grouping ("day", "week", "month", "year").}

\item{show_smooth_trend}{A logical value indicating whether to show the overall smooth trend line (default: TRUE).}
}
\value{
A ggplot object representing the sentiment trend.
}
\description{
This function plots the average sentiment score over time.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the scrape_reviews function
reviews <- scrape_reviews(temp_file, num_reviews = 10, use_parallel = FALSE)

# Check if reviews were successfully scraped
if (nrow(reviews) > 0) {
  # Perform sentiment analysis
  sentiment_results <- analyze_sentiment(reviews, lexicon = "afinn")

  # Create histogram of sentiment scores
  senti_trend <- sentiment_trend(sentiment_results)

  # Display the plot
  print(senti_trend)

  # Optionally, save the plot
  # ggsave("senti_trend.png", senti_trend, width = 8, height = 6)
} else {
  cat("No reviews found. Cannot create sentiment trend\n")
}

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
