% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitrd_GetITRData.R
\name{gitrd.GetITRData}
\alias{gitrd.GetITRData}
\title{Downloads and reads financial reports from Bovespa}
\usage{
gitrd.GetITRData(name.companies, first.date = Sys.Date() - 12 * 30,
  last.date = Sys.Date(), type.info = "individual",
  inflation.index = "none", folder.out = tempdir(), be.quiet = FALSE)
}
\arguments{
\item{name.companies}{Official names of companies to get financial reports (e.g. 'PETROBRAS'). Names of companies can be found using function gitrd.get.info.companies()}

\item{first.date}{First date (YYYY-MM-DD) to get data. Character or Date. E.g. first.date = '2010-01-01'.}

\item{last.date}{Last date (YYYY-MM-DD) to get data. Character or Date. E.g. last.date = '2017-01-01'.}

\item{type.info}{Type of financial statements, 'individual' (default) or 'consolidated'. Argument can be a single value or a vector with the same
length as name.companies. The individual type only includes financial statements from the company itself, while consolidated statements adds information
about controlled companies}

\item{inflation.index}{Set which inflation index to use for finding inflation adjusted values of all reports. Possible values: 'none' (default), 'IPCA' - main brazilian inflation index and 'dollar'.
When using 'IPCA', the base date as set as the last date found in the inflation dataset.}

\item{folder.out}{Folder where to download and manipulate the zip files. Default = tempdir()}

\item{be.quiet}{Should the function output information about progress? TRUE (default) or FALSE}
}
\value{
A tibble (dataframe with lists) object with all gathered financial statements, with each company as a row in the tibble.
}
\description{
Quarterly financial reports are downloaded from Bovespa for a combination of companies and time period. The downloaded
zip file is read by a custom function, which outputs several information that are organized and structured by this function.
The easist way to get started with gitrd.GetITRData is looking for the official name of traded companies using function gitrd.search.company('nametolookfor').
Alternatively, you can use function gitrd.get.info.companies to import a dataframe with information for all available companies and time periods.
}
\examples{

\dontrun{ #dontrun: keep cran check time short
name.companies <- 'PETROBRAS'
first.date <- '2005-01-01'
last.date <-  '2006-01-01'

df.statements <- gitrd.GetITRData(name.companies = name.companies,
                                  first.date = first.date,
                                  last.date = last.date)
 }
}
