% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_input_data.R
\name{read_input_data}
\alias{read_input_data}
\title{read sequence data from file to be used in simulation}
\usage{
read_input_data(
  file_names,
  type,
  chosen_chromosome,
  number_of_snps = NA,
  random_snps = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{file_names}{names of input files}

\item{type}{type of data, options are 'ped' and 'vcf'}

\item{chosen_chromosome}{GenomeAdmixR simulates only a single chromosome.}

\item{number_of_snps}{number of snps to be loaded from file, default
is to load all snps}

\item{random_snps}{if a subset of all snps has to be taken, should these
be sampled sequentially (e.g. the first 100 snps) or randomly (100 randomly
sampled snps) (examples are for 'number_of_snps' = 100).}

\item{verbose}{give verbose output}
}
\value{
list with two properties: \code{genomes} a matrix with the
sequence translated to numerics, such that [actg] corresponds to [1234], and
missing data is represented with "-". Rows in the matrix correspond to
chromosomes, and columns represent bases. Two consecutive rows represent an
individual, such that rows 1-2 are individual, rows 3-4 are one individual
etc. \code{markers} corresponds to the locations of the markers (in bp) on
the chosen chromosome.
}
\description{
Create data in a format that can be used by GenomeAdmixR
}
