% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.GenericML}
\alias{print.GenericML}
\title{Print method for a \code{GenericML} object}
\usage{
\method{print}{GenericML}(x, ...)
}
\arguments{
\item{x}{An instance of \code{\link{GenericML}}.}

\item{...}{Additional arguments to be passed down.}
}
\value{
A print to the console.
}
\description{
Prints key results of the analyses conducted in \code{\link{GenericML}}.
}
\examples{
if(require("glmnet")){

## generate data
set.seed(1)
n  <- 150                                  # number of observations
p  <- 5                                    # number of covariates
D  <- rbinom(n, 1, 0.5)                    # random treatment assignment
Z  <- matrix(runif(n*p), n, p)             # design matrix
Y0 <- as.numeric(Z \%*\% rexp(p) + rnorm(n)) # potential outcome without treatment
Y1 <- 2 + Y0                               # potential outcome under treatment
Y  <- ifelse(D == 1, Y1, Y0)               # observed outcome

## specify learners
learners <- c("lasso")

## perform generic ML inference
# small number of splits to keep computation time low
x <- GenericML(Z, D, Y, learners, num_splits = 2,
               parallel = FALSE)

## print
print(x)
}

}
