#' Package for testing conditional independence based on the Generalized Covariance Measure (GCM)
#'
#' Contains the function gcm.test that can be used for performing a conditional independence test based on the GCM.
#'
#' @references
#' Please cite the following paper.
#' Rajen D. Shah, Jonas Peters:
#' "The Hardness of Conditional Independence Testing and the Generalised Covariance Measure"
#' \url{https://arxiv.org/abs/1804.07203}
#'
#' @docType package
#'
#' @import CVST kernlab mgcv xgboost
#'
#' @importFrom stats formula pnorm rnorm
#' @importFrom graphics par
#'
#' @author Jonas Peters \email{jonas.peters@math.ku.dk}, Rajen D. Shah
#'
#' @name GeneralisedCovarianceMeasure
NULL
