% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfunctions.R
\name{PlotDic}
\alias{PlotDic}
\title{Plot atoms of a given dictionary}
\usage{
PlotDic(D, n1 = NULL, n2 = NULL, m1 = NULL, m2 = NULL, title = NULL,
  color = F, background = "black")
}
\arguments{
\item{D}{Dictionary of size m by p}

\item{n1, n2}{(Optional) Number of patches to be displayed in each column and
each row. If specified, both n1 and n2 have to be specified.}

\item{m1, m2}{(Optional) Size of the small patch to be mapped. Default is
m1=m2=sqrt(m). If specified, both n1 and n2 have to be specified.}

\item{title}{Title of the plot.}

\item{color}{(Optional) If TRUE, the plot is generated using tim.colors()
option. If FALSE, the plot is generated using gray scale. Default is FALSE.}

\item{background}{(Optional) Backgroup color. Default is black.}
}
\value{
Plot will be generated.
}
\description{
Given a learned dictionary D (m by p) matrix, this function plots all p atoms
of D corresponding to p columns. Each column is mapped to a m1 by m2 small
pactch.
}
\examples{
D=matrix(runif(64*100),nrow=64)
# PlotDic(D)
}
