% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{phenoRegressor.rrBLUP}
\alias{phenoRegressor.rrBLUP}
\title{SNP-BLUP or G-BLUP using rrBLUP package}
\usage{
phenoRegressor.rrBLUP(phenotypes, genotypes = NULL, covariances = NULL,
  extraCovariates = NULL, ...)
}
\arguments{
\item{phenotypes}{phenotypes, a numeric array (n x 1), missing values are predicted}

\item{genotypes}{SNP genotypes, one row per phenotype (n), one column per marker (m), values in 0/1/2 for
diploids or 0/1/2/...ploidy for polyploids. Can be NULL if \code{covariances} is present.}

\item{covariances}{square matrix (n x n) of covariances.}

\item{extraCovariates}{optional extra covariates set, one row per phenotype (n), one column per covariate (w).
If NULL no extra covariates are considered.}

\item{...}{extra parameters are passed to rrBLUP::mixed.solve}
}
\value{
The function returns a list with the following fields:
\itemize{
  \item \code{predictions} : an array of (k) predicted phenotypes
  \item \code{hyperparams} : named vector with the following keys: Vu, Ve, beta, LL
  \item \code{extradata}   : list with information on trained model, coming from \code{\link[rrBLUP]{mixed.solve}}
}
}
\description{
This is a wrapper around \code{rrBLUP} function \code{\link[rrBLUP]{mixed.solve}}.
It can either work with genotypes (in form of a SNP matrix) or with kinships (in form of a covariance
matrix). In the first case the function will implement a SNP-BLUP, in the second a G-BLUP. An error is
returned if both SNPs and covariance matrix are passed.\cr
In rrBLUP terms, genotypes are modeled as random effects (matrix Z), covariances as matrix K, and
extra covariates, if present, as fixed effects (matrix X).\cr
Please note that this function won't work if rrBLUP package is not installed.
}
\examples{
\dontrun{
#using the GROAN.KI dataset, we regress on the dataset and predict the first ten phenotypes
phenos = GROAN.KI$yield
phenos[1:10]  = NA

#calling the regressor with ridge regression BLUP on SNPs and kinship
results.SNP.BLUP = phenoRegressor.rrBLUP(
  phenotypes = phenos,
  genotypes = GROAN.KI$SNPs,
  SE = TRUE, return.Hinv = TRUE #rrBLUP-specific parameters
)
results.G.BLUP = phenoRegressor.rrBLUP(
  phenotypes = phenos,
  covariances = GROAN.KI$kinship,
  SE = TRUE, return.Hinv = TRUE #rrBLUP-specific parameters
)

#examining the predictions
plot(GROAN.KI$yield, results.SNP.BLUP$predictions,
     main = '[SNP-BLUP] Train set (black) and test set (red) regressions',
     xlab = 'Original phenotypes', ylab = 'Predicted phenotypes')
abline(a=0, b=1)
points(GROAN.KI$yield[1:10], results.SNP.BLUP$predictions[1:10], pch=16, col='red')

plot(GROAN.KI$yield, results.G.BLUP$predictions,
     main = '[G-BLUP] Train set (black) and test set (red) regressions',
     xlab = 'Original phenotypes', ylab = 'Predicted phenotypes')
abline(a=0, b=1)
points(GROAN.KI$yield[1:10], results.G.BLUP$predictions[1:10], pch=16, col='red')

#printing correlations
correlations = data.frame(
  model = 'SNP-BLUP',
  test_set_correlations = cor(GROAN.KI$yield[1:10], results.SNP.BLUP$predictions[1:10]),
  train_set_correlations = cor(GROAN.KI$yield[-(1:10)], results.SNP.BLUP$predictions[-(1:10)])
)
correlations = rbind(correlations, data.frame(
  model = 'G-BLUP',
  test_set_correlations = cor(GROAN.KI$yield[1:10], results.G.BLUP$predictions[1:10]),
  train_set_correlations = cor(GROAN.KI$yield[-(1:10)], results.G.BLUP$predictions[-(1:10)])
))
print(correlations)
}
}
\seealso{
\link[rrBLUP]{mixed.solve}

Other phenoRegressors: \code{\link{phenoRegressor.BGLR}},
  \code{\link{phenoRegressor.RFR}},
  \code{\link{phenoRegressor.SVR}},
  \code{\link{phenoRegressor.dummy}}
}
\concept{phenoRegressors}
