% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise_injectors.R
\name{noiseInjector.unif}
\alias{noiseInjector.unif}
\title{Inject Uniform Noise}
\usage{
noiseInjector.unif(phenotypes, min = 0, max = 1, subset = 1)
}
\arguments{
\item{phenotypes}{an array of numbers.}

\item{min, max}{lower and upper limits of the distribution. Must be finite.}

\item{subset}{integer in [0,1], the proportion of original dataset to be injected}
}
\value{
An array, of the same size as phenotypes, where uniform noise has been added to
        the original phenotype values.
}
\description{
This function adds to the passed \code{phenotypes} array noise sampled from
a uniform distribution with the specified range.\cr
The function can interest the totality of the passed phenotype array or
a random subset of it (commanded by \code{subset} parameter).
}
\examples{
#a sinusoid signal
phenos = sin(seq(0,5, 0.1))
plot(phenos, type='p', pch = 16, main='Original (black) vs. Injected (red), 100\% affected')

#adding normal noise to all samples
phenos.noise = noiseInjector.unif(phenos, min=0.1, max=0.3)
points(phenos.noise, type='p', col='red')

#adding noise only to 30\% of the samples
plot(phenos, type='p', pch = 16, main='Original (black) vs. Injected (red), 30\% affected')
phenos.noise.subset = noiseInjector.unif(phenos, min=0.1, max=0.3, subset = 0.3)
points(phenos.noise.subset, type='p', col='red')
}
\seealso{
Other noiseInjectors: \code{\link{noiseInjector.dummy}},
  \code{\link{noiseInjector.norm}},
  \code{\link{noiseInjector.swapper}}
}
\concept{noiseInjectors}
