% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise_injectors.R
\name{noiseInjector.swapper}
\alias{noiseInjector.swapper}
\title{Swap phenotypes between samples}
\usage{
noiseInjector.swapper(phenotypes, subset = 0.1)
}
\arguments{
\item{phenotypes}{an array of numbers}

\item{subset}{fraction of phenotypes to be interested by noise.}
}
\value{
the same passed \code{phenotypes}, but with some elements swapped
}
\description{
This function introduces swap noise, i.e. a number of couples of
samples will have their phenotypes swapped.\cr
The number of couples is computed so that the total fraction of
interested phenotypes approximates \code{subset}.
}
\examples{
#a set of phenotypes
phenos = 1:10
#swapping two elements
phenos.sw2 = noiseInjector.swapper(phenos, 0.2)
#swapping four elements
phenos.sw4 = noiseInjector.swapper(phenos, 0.4)
#swapping four elements again, since 30\% of 10 elements
#is rounded to 4 (two couples)
phenos.sw4.again = noiseInjector.swapper(phenos, 0.3)
}
\seealso{
Other noiseInjectors: \code{\link{noiseInjector.dummy}},
  \code{\link{noiseInjector.norm}},
  \code{\link{noiseInjector.unif}}
}
\concept{noiseInjectors}
