% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GOCore.R
\name{chord_dat}
\alias{chord_dat}
\title{Creates a binary matrix.}
\usage{
chord_dat(data, genes, process)
}
\arguments{
\item{data}{A data frame with coloumns for GO ID|term and genes.}

\item{genes}{A character vector of selected genes OR data frame with coloumns
for gene ID and logFC.}

\item{process}{A character vector of selected processes}
}
\value{
A binary matrix
}
\description{
The function creates a matrix which represents the binary
  relation (1= is related to, 0= is not related to) between selected genes
  (row) and processes (column). The resulting matrix can be visualized with
  the \code{\link{GOChord}} function.
}
\details{


If more than one logFC value for each gene is at disposal, only one
  should be used to create the binary matrix. The other values have to be
  added manually later.
}
\examples{
\dontrun{
#Load the included dataset
data(EC)

#Building the circ object
circ<-circular_dat(EC$david, EC$genelist)

#Building the binary matrix
chord<-chord_dat(circ, EC$genes, EC$process)
}
}
\seealso{
\code{\link{GOChord}}
}

