% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{frank.flm2d}
\alias{frank.flm2d}
\title{F rank functional GLM for images}
\usage{
frank.flm2d(nsim, formula.full, formula.reduced, image_sets,
  factors = NULL, ...)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{formula.full}{The formula specifying the general linear model,
see \code{formula} in \code{\link[stats]{lm}}.}

\item{formula.reduced}{The formula of the reduced model with nuisance factors only. This model
should be nested within the full model.}

\item{image_sets}{A named list of sets of images giving the dependent variable (Y), and
possibly additionally all the factors. The dimensions of the elements should
match with each other, i.e. the factor values should be given for each argument value
and each function.}

\item{factors}{A data frame of factors. An alternative way to specify factors when they
are constant for all argument values. The number of rows of the data frame should be equal
to the number of curves. Each column should specify the values of a factor.}

\item{...}{Additional parameters to be passed to \code{\link{frank.flm}}.
The possibly saved simulations are currently only provided in a vector format.}
}
\value{
A \code{global_envelope2d} object, which can be printed and plotted
directly.
}
\description{
Multiple testing in permutation inference for the general linear model (GLM)
}
\examples{
\donttest{
data("imageset2")
# Testing discrete factor group
res.g <- frank.flm2d(nsim = 19, # Increase nsim for serious analysis!
                     formula.full = Y ~ group + z,
                     formula.reduced = Y ~ z,
                     image_sets = list(Y = imageset2$image_set),
                     factors = data.frame(group = imageset2$Group,
                                          z = imageset2$z))
plot(res.g)

# Testing continuous factor z
res.z <- frank.flm2d(nsim = 19, # Increase nsim for serious analysis!
                     formula.full = Y ~ group + z,
                     formula.reduced = Y ~ group,
                     image_sets = list(Y = imageset2$image_set),
                     factors = data.frame(group = imageset2$Group,
                                          z = imageset2$z))
plot(res.z)
}
}
\references{
Mrkvička, T., Myllymäki, M. and Narisetty, N. N. (2019) New methods for multiple testing in permutation inference for the general linear model. arXiv:1906.09004 [stat.ME]
}
\seealso{
\code{\link{frank.flm}}, \code{\link{graph.flm2d}}
}
