% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-special_functions.R
\docType{methods}
\name{arctan2}
\alias{arctan2}
\alias{arctan2,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\title{Arc-tangent}
\usage{
\S4method{arctan2}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(y, x)
}
\arguments{
\item{y}{a PiecewiseLinearFuzzyNumber}

\item{x}{a PiecewiseLinearFuzzyNumber}
}
\value{
Returns a fuzzy number of the class \linkS4class{PiecewiseLinearFuzzyNumber}
indicating the angle specified by the input fuzzy numbers. The range of results is
[-1.5pi,pi].
}
\description{
The arc-tangent of two arguments arctan2(y, x) returns the angle between 
the x-axis and the vector from the origin to (x, y) for PiecewiseLinearFuzzyNumbers.
}
\details{
Note that resulting values are no longer from interval [-pi,pi] but 
[-1.5pi,pi], in order to provide valid fuzzy numbers as result.
}
\examples{
y = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-2, 3, 5), knot.n = 9)
x = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-4.8, -4, 1.5), knot.n = 9)
arctan2(y,x)
}
\seealso{
Other PiecewiseLinearFuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{PiecewiseLinearFuzzyNumber-class}},
  \code{\link{PiecewiseLinearFuzzyNumber}},
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{alphaInterval}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}},
  \code{\link{expectedInterval}}, \code{\link{fapply}},
  \code{\link{maximum}}, \code{\link{minimum}},
  \code{\link{necessityExceedance}},
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityUndervaluation}},
  \code{\link{plot}}, \code{\link{possibilityExceedance}},
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictUndervaluation}},
  \code{\link{possibilityUndervaluation}}
}

