% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.FluMoDL.R
\name{summary.FluMoDL}
\alias{summary.FluMoDL}
\title{Summary method for FluMoDL objects}
\usage{
\method{summary}{FluMoDL}(object, ...)
}
\arguments{
\item{object}{An object of class 'FluMoDL'}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class 'summary.FluMoDL'. This is a list containing the following elements:
  \describe{
    \item{$type}{A string describing the meaning of the coefficients. Defaults to
    "summary", meaning a first-stage model summary. Alternatively, "blup" means
    Best Unbiased Linear Predictor (BLUP) coefficients, and "pooled" refers to coefficients
    pooled in the course of a multivariate meta-analysis. See \code{\link{metaFluMoDL}}.}

    \item{$description}{A string with an additional description. For objects created
    with \code{summary.FluMoDL()} it is an empty string, but see \code{\link{metaFluMoDL}}.}

    \item{$coef}{A list of numeric vectors, with names 'proxyH1', 'proxyH3' and 'proxyB'
    (and 'proxyRSV' if provided in the function arguments), containing the model
    coefficients for these terms.}

    \item{$vcov}{A list of variance-covariance matrices, with names 'proxyH1', 'proxyH3'
    and 'proxyB' (and 'proxyRSV' if provided in the function arguments), for the respective
    model coefficients.}

    \item{$pred}{A list with names 'proxyH1', 'proxyH3' and 'proxyB' (and 'proxyRSV'
    if provided in the function arguments), containing
    predictions (in the form of \code{\link[dlnm]{crosspred}} objects) for each exposure.
    These can be plotted in both the exposure-response and lag-response dimensions, see
    \code{\link[dlnm]{crosspred}}, \code{\link[dlnm]{plot.crosspred}} and the example below.}
  }
}
\description{
This function creates a summarized version of a 'FluMoDL' object. It contains
the sets of coefficients and variance-covariance matrices for the incidence
proxy terms (for influenza, and for RSV if provided), and the predictions for these terms.
}
\details{
These summaries can be used to run a \code{\link[=metaFluMoDL]{multivariate meta-analysis}} and calculate
pooled effect estimates and BLUP (Best Unbiased Linear Predictor) estimates
for influenza (and RSV if provided).
}
\examples{
data(greece) # Use example surveillance data from Greece
m <- with(greece, fitFluMoDL(deaths = daily$deaths,
    temp = daily$temp, dates = daily$date,
    proxyH1 = weekly$ILI * weekly$ppH1,
    proxyH3 = weekly$ILI * weekly$ppH3,
    proxyB = weekly$ILI * weekly$ppB,
    yearweek = weekly$yearweek))
summ <- summary(m)
summ

# Plot the association between A(H1N1)pdm09 activity and mortality:
plot(summ$pred$proxyH1, "overall")

}
