% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_partially_replicated.R
\name{partially_replicated}
\alias{partially_replicated}
\title{Generates a Spatial Partially Replicated Arrangement Design}
\usage{
partially_replicated(
  nrows = NULL,
  ncols = NULL,
  repGens = NULL,
  repUnits = NULL,
  planter = "serpentine",
  l = 1,
  plotNumber = 101,
  seed = NULL,
  exptName = NULL,
  locationNames = NULL,
  data = NULL
)
}
\arguments{
\item{nrows}{Number of rows field.}

\item{ncols}{Number of columns field.}

\item{repGens}{Numeric vector with the amount genotypes to replicate.}

\item{repUnits}{Numeric vector with the number of reps of each genotype.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} movement. By default  \code{planter = 'serpentine'}.}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{exptName}{(optional) Name of the experiment.}

\item{locationNames}{(optional) Name for each location.}

\item{data}{(optional) Dataframe with 3 columns: \code{ENTRY | NAME | REPS}.}
}
\value{
A list with five elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{layoutRandom} is a matrix with the randomization layout.
  \item \code{plotNumber} is a matrix with the layout plot number.
  \item \code{dataEntry} is a data frame with the data input.
  \item \code{genEntries} is a list with the entries for replicated and no replicated part.
  \item \code{fieldBook} is a data frame with field book design. This includes the index (Row, Column).
}
}
\description{
Randomly generates a spatial partially replicated design, where the distance 
between checks is maximized in such a way that each row and column have control plots. 
Note that design generation needs the dimension of the field (number of rows and columns).
}
\examples{
# Example 1: Generates a spatial optimized partially replicated arrangement design in one 
# location with 312 genotypes for a field with dimensions 15 rows x 28 cols. 
# Note that there are 250 genotypes unreplicated (only one time), 50 genotypes replicated 
# two times, and 10 genotypes replicated three times, and two checks 20 times each one.
SpatpREP1 <- partially_replicated(
  nrows = 15, 
  ncols = 28,  
  repGens = c(250,50,10,1,1),
  repUnits = c(1,2,3,20,20),
  planter = "cartesian", 
  plotNumber = 101,
  seed = 77
 )
SpatpREP1$infoDesign
SpatpREP1$layoutRandom
SpatpREP1$plotNumber
head(SpatpREP1$fieldBook,12)

# Example 2: Generates a spatial optimized partially replicated arrangement design with 492 
# genotypes in a field with dimensions 30 rows x 20 cols. Note that there 384 genotypes 
# unreplicated (only one time), 108 genotypes replicated two times. 
# In this case we don't have check plots.
# As example, we set up the data option with the entries list.
NAME <- paste("G", 1:492, sep = "")
repGens = c(108, 384);repUnits = c(2,1)
REPS <- rep(repUnits, repGens)
treatment_list <- data.frame(list(ENTRY = 1:492, NAME = NAME, REPS = REPS))
head(treatment_list, 12) 
tail(treatment_list, 12)
SpatpREP2 <- partially_replicated(nrows = 30, 
                                  ncols = 20, 
                                  planter = "serpentine", 
                                  plotNumber = 101,
                                  seed = 41,
                                  data = treatment_list)
SpatpREP2$infoDesign
SpatpREP2$layoutRandom
SpatpREP2$plotNumber
head(SpatpREP2$fieldBook,10)

}
\references{
Cullis, S., B. R., & Coombes, N. E. (2006). On the design of early generation variety trials
with correlated data. Journal of Agricultural, Biological, and Environmental Statistics, 11,
381–393. https://doi.org/10.1198/108571106X154443
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
