% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepro.R
\name{plot_lm_suitability}
\alias{plot_lm_suitability}
\title{Plot the suitability of predictors for linear models}
\usage{
plot_lm_suitability(
  slist = check_lm_suitability(),
  pdfpath = tempfile("lm_suitability", fileext = ".pdf"),
  descs = NULL
)
}
\arguments{
\item{slist}{A list containing the data frame \code{df}, the matrix \code{X}, and the data frame \code{V} from \code{check_lm_suitability()}.}

\item{pdfpath}{The path to the pdf file to save the plots.}

\item{descs}{Index of chemical descriptors to plot. Leave at NULL to plot all chemical descriptors.}
}
\value{
No return value. The function is used for its side effect of creating a pdf file with the plots.
}
\description{
This function creates one pdf page for every predictor inside \code{slist$X}. The pdf page consists of the following three plots shown next to each other:
\enumerate{
\item Histogram
\item Density plot
\item Scatterplot against \code{slist$df$RT}
The name of the predictor, its suitability, and the status of the checks for missing values, near-zero variance, and outliers are shown in the title of each plot.
}
}
\examples{
df <- head(RP, 3)
slist <- check_lm_suitability(df, verbose = FALSE, nw = 1)
plot_lm_suitability(slist, descs = 1:5)
}
\seealso{
\code{\link[=check_lm_suitability]{check_lm_suitability()}}
}
\keyword{internal}
