% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunLDA.R
\name{FitLDAModelNewTissues}
\alias{FitLDAModelNewTissues}
\title{Update the tissues in a fitted LDA model}
\usage{
FitLDAModelNewTissues(newtissue.data, summary.c, inner.iters = 200)
}
\arguments{
\item{newtissue.data}{A data frame with character-valued columns 
rs and cat and numeric-valued columns with annotations.
Each row contains data for one SNP in one tissue
rs is an ID for the SNP, which need not be unique, and
cat is an ID for each tissue, which must match an ID
for which training data was included when fitting the
LDA model.  Annotation columns must have column names matching
those supplied when fitting the LDA model.}

\item{summary.c}{A fitted LDA model created using 
\code{\link{FitLDAModel}} or \code{\link{FitLDAModelNewTissues}}.}

\item{inner.iters}{Integer specifying number of inner iterations}
}
\value{
a fitted LDA model, as returned by \code{\link{FitLDAModel}},
        that can be used with \code{\link{Predict}} for
        the tissues in newtissue.data
}
\description{
Update the tissues in a fitted LDA model
}
\examples{
\dontrun{
  data(training)
  summary.c <- FitLDAModel(training.data=training, nclust=3,
                         kde.nbins=100, iters=50, inner.iters=50)
  data(tissuenew)
  newtissues <- FitLDAModelNewTissues(newtissue.data=tissuenew,
                                     summary.c=summary.c,
                                     inner.iters=50)
}
}
