% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunLDA.R
\name{FitLDAModel}
\alias{FitLDAModel}
\title{fit an LDA model}
\usage{
FitLDAModel(training.data, nclust = 9, kde.nbins = 1000, iters = 250,
  inner.iters = 200)
}
\arguments{
\item{training.data}{A data frame with character-valued columns 
rs and cat and numeric-valued columns with annotations.
Each row is data for one SNP in one tissue.
rs is an ID for the SNP, which need not be unique, and
cat is an ID for each tissue.}

\item{nclust}{Integer specifying the number of clusters to estimate}

\item{kde.nbins}{Integer specifying how many bins to use for binning 
each annotation}

\item{iters}{Integer specifying number of outer iterations}

\item{inner.iters}{Integer specifying number of inner iterations}
}
\value{
A fitted LDA model, i.e., a list (apart from elements
        used internally) with elements
        \describe{
            \item{p.labeled}{a data frame with one row per 
                             training variant, with
                             the posterior probability for each 
                             variant to be in 
                             each cluster in columns CLUSTER1,... and
                             also with columns cat and rs}
            \item{a.labeled}{a data frame with one row per tissue
                             with membership vectors for each tissue
                             with columns cat and CLUSTER1,...}
        }
}
\description{
fit an LDA model
}
\examples{
\dontrun{
  data(training)
  summary.c <- FitLDAModel(training.data=training, nclust=3,
                         kde.nbins=100, iters=50, inner.iters=50)
}
}
