% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VendaceLP2.R
\docType{data}
\name{VendaceLP2}
\alias{VendaceLP2}
\title{Stock and recruitment data for Vendace from Lake Pyhajarvi.}
\format{A data frame of 9 observations on the following 2 variables:
 \describe{
   \item{fecundity}{Total fecundity (10^9 eggs) of spawning stock}
   \item{recruits}{Number of recruits (10^6 fish) in Autumn after hatching}
 }}
\source{
From (approximately) Figure 6 in Helminen, H. and J. Sarvala. 1994. Population regulation of vendance (\emph{Coregonus albula}) in Lake Pyhajarvi, southwest Finland.  Journal of Fish Biology 45:387-400.
}
\description{
Vendace (\emph{Coregonus albula}) recruitment in Lake Pyhajarvi.
}
\note{
Original authors fit an exponential curve to the fecundity-recruits relationship.
}
\section{Topic(s)}{

 \itemize{
   \item Stock-Recruit
   \item Recruitment
 }
}
\examples{
data(VendaceLP2)
str(VendaceLP2)
head(VendaceLP2)
plot(recruits~fecundity,data=VendaceLP2)
}
\concept{
'Stock-Recruit' Recruitment
}
\keyword{datasets}

