% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthModels.R
\name{SchnuteRichards}
\alias{SchnuteRichards}
\title{The five-parameter growth function from Schnute and Richards (1990).}
\usage{
SchnuteRichards(t, Linf = NULL, k = NULL, a = NULL, b = NULL, c = NULL)
}
\arguments{
\item{t}{A numeric vector of ages over which to model growth.}

\item{Linf}{Mean asymptotic length.}

\item{k}{The "growth coefficient" with units of (year^(-c)).}

\item{a}{A dimensionless parameter}

\item{b}{A dimensionless parameter.}

\item{c}{A dimensionless parameter.}
}
\value{
\code{SchnuteRichards} returns a predicted size given the provided parameter values.
}
\description{
The five-parameter growth function from Schnute and Richards (1990). Note that this function is slightly modified (a \sQuote{+} was changed to a \sQuote{-} so that the \sQuote{a} parameter will be positive) from the original in Schnute and Richards (1990)
}
\section{IFAR Chapter}{
 None specifically, but 12-Individual Growth is related.
}

\examples{
## See the formulae
growthFunShow("SchnuteRichards",plot=TRUE)

## Simple examples
ages <- 1:15
s1 <- SchnuteRichards(ages,Linf=100,k=0.03,a=0.01,b=0.005,c=2)
plot(s1~ages,type="l",lwd=2)

}
\references{
Schnute, J.T. and L.J. Richards. 1990. A unified approach to the analysis of fish growth, maturity, and survivorship data. Canadian Journal of Fisheries and Aquatic Sciences. 47:24-40.
}
\seealso{
See \code{\link{vbFuns}}, \code{\link{GompertzFuns}}, \code{\link{RichardsFuns}}, \code{\link{logisticFuns}}, and \code{\link{Schnute}} for similar functionality for other models.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{manip}
