% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageComparisons.R
\name{plotAB}
\alias{plotAB}
\title{Construct traditional (Campana-like) age-bias plots.}
\usage{
plotAB(x, what = c("bias", "Campana", "numbers"), xlab = x$ref.lab,
  ylab = x$nref.lab, xlim = NULL, ylim = NULL,
  yaxt = graphics::par("yaxt"), xaxt = graphics::par("xaxt"),
  col.agree = "gray60", lwd.agree = lwd, lty.agree = 2, lwd = 1,
  sfrac = 0, pch.mean = 19, pch.mean.sig = 21, cex.mean = lwd,
  col.CI = "black", col.CIsig = "red", lwd.CI = lwd,
  sfrac.CI = sfrac, show.n = FALSE, nYpos = 1.03, cex.n = 0.75,
  cex.numbers = 0.75, col.numbers = "black", ...)
}
\arguments{
\item{x}{An object of class \code{ageBias}, usually a result from \code{ageBias}.}

\item{what}{A string that indicates what type of plot to construct. See details.}

\item{xlab, ylab}{A string label for the x-axis (reference) or y-axis (non-reference) age estimates, respectively.}

\item{xlim, ylim}{A numeric vector of length 2 that contains the limits of the x-axis (reference ages) or y-axis (non-reference ages), respectively.}

\item{xaxt, yaxt}{A string which specifies the x- and y-axis types. Specifying \dQuote{n} suppresses plotting of the axis. See \code{?par}.}

\item{col.agree}{A string or numeric for the color of the 1:1 or zero (if \code{difference=TRUE}) reference line.}

\item{lwd.agree}{A numeric for the line width of the 1:1 or zero (if \code{difference=TRUE}) reference line.}

\item{lty.agree}{A numeric for the line type of the 1:1 or zero (if \code{difference=TRUE}) reference line.}

\item{lwd}{A numeric that controls the separate \sQuote{lwd} argument (e.g., \code{lwd.CI} and \code{lwd.range}).}

\item{sfrac}{A numeric that controls the separate \sQuote{sfrac} arguments (e.g., \code{sfrac.CI} and \code{sfrac.range}). See \code{sfrac} in \code{\link[plotrix]{plotCI}} of \pkg{plotrix}.}

\item{pch.mean}{A numeric for the plotting character used for the mean values when the means are considered insignificant.}

\item{pch.mean.sig}{A numeric for the plotting character for the mean values when the means are considered significant.}

\item{cex.mean}{A character expansion value for the size of the mean symbol in \code{pch.mean} and \code{pch.mean.sig}.}

\item{col.CI}{A string or numeric for the color of confidence interval bars that are considered non-significant.}

\item{col.CIsig}{A string or numeric for the color of confidence interval bars that are considered significant.}

\item{lwd.CI}{A numeric for the line width of the confidence interval bars.}

\item{sfrac.CI}{A numeric for the size of the ends of the confidence interval bars. See \code{sfrac} in \code{\link[plotrix]{plotCI}} of \pkg{plotrix}.}

\item{show.n}{A logical for whether the sample sizes for each level of the x-axis variable is shown (\code{=TRUE}, default) or not (\code{=FALSE}).}

\item{nYpos}{A numeric for the relative Y position of the sample size values when \code{show.n=TRUE}. For example, if \code{nYpos=1.03} then the sample size values will be centered at 3 percent above the top end of the y-axis.}

\item{cex.n}{A character expansion value for the size of the sample size values.}

\item{cex.numbers}{A character expansion value for the size of the numbers plotted when \code{what="numbers"} is used.}

\item{col.numbers}{A string for the color of the numbers plotted when \code{what="numbers"} is used.}

\item{\dots}{Additional arguments for methods.}
}
\value{
Nothing, but see details for a description of the plot that is produced.
}
\description{
Constructs a traditional (e.g., like that described in Campana \emph{et al.} (1995)) age-bias plot to visualize potential differences in paired age estimates. Ages may be from, for example, two readers of the same structure, one reader at two times, two structures (e.g., scales, spines, otoliths), or one structure and known ages.
}
\details{
Two types of plots for visualizing differences between sets of two age estimates may be created. The reference ages are plotted on the x-axis and the nonreference ages are on the y-axis. The 1:1 (45 degree) agreement line is shown for comparative purposes. The default plot (using \code{what="bias"}) was inspired by the age bias plot introduced by Campana \emph{et al.} (1995). The default settings for this age bias plot show the mean and confidence interval for the nonreference ages at each of the reference ages. The level of confidence is controlled by \code{sig.level=} given in the original \code{\link{ageBias}} call (i.e., confidence level is 100*(1-\code{sig.level})). Confidence intervals are only shown if the sample size is greater than the value in \code{min.n.CI=} (also from the original call to \code{\link{ageBias}}). Confidence intervals plotted in red with an open dot (by default; these can be changed with \code{col.CIsig} and \code{pch.mean.sig}, respectively) do not contain the reference age (see discussion of t-tests in \code{\link{ageBias}}). Sample sizes at each reference age are shown if \code{show.n=TRUE}. The position of the sample sizes is controlled with \code{nYpos=}, whereas their size is controlled with \code{cex.n}. Arguments may be used to nearly replicate the age bias plot as introduced by Campana \emph{et al.} (1995) as shown in the examples.

The frequency of observations at each unique (x,y) coordinate are shown by using \code{what="numbers"} in \code{plotAB}. The size of the numbers is controlled with \code{cex.numbers}.
}
\section{IFAR Chapter}{
 4-Age Comparisons. \bold{This is most of the original functionality that was in \code{plot} in the book. See examples.}
}

\examples{
# Must create ageBias object first
ab1 <- ageBias(scaleC~otolithC,data=WhitefishLC,
               ref.lab="Otolith Age",nref.lab="Scale Age")
               
# Default plot
plotAB(ab1)

# Very close to Campana et al. (2001)
plotAB(ab1,pch.mean.sig=19,col.CIsig="black",sfrac=0.01,
       ylim=c(-1,23),xlim=c(-1,23))
# Show sample sizes (different position and size than default)
plotAB(ab1,show.n=TRUE,nYpos=0.02,cex.n=0.5)

# Traditional numbers plot
plotAB(ab1,what="numbers") 

}
\references{
Campana, S.E., M.C. Annand, and J.I. McMillan. 1995. Graphical and statistical methods for determining the consistency of age determinations. Transactions of the American Fisheries Society 124:131-138. [Was (is?) available from http://www.bio.gc.ca/otoliths/documents/Campana\%20et\%20al\%201995\%20TAFS.pdf.]
}
\seealso{
See \code{\link{ageBias}} and its plot method for what I consider a better age-bias plot; \code{\link{agePrecision}} for measures of precision between pairs of age estimates; and \code{\link[fishmethods]{compare2}} in \pkg{fishmethods} for similar functionality.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{htest}
\keyword{manip}
