% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/basisfns.R
\docType{methods}
\name{remove_basis}
\alias{remove_basis}
\alias{remove_basis,Basis-method}
\title{Removes basis functions}
\usage{
remove_basis(Basis, rmidx)

\S4method{remove_basis}{Basis}(Basis, rmidx)
}
\arguments{
\item{Basis}{object of class \code{Basis}}

\item{rmidx}{indices of basis functions to remove}
}
\description{
Takes a an object of class \code{Basis} and returns an object of class \code{Basis} with selected basis functions removed.
}
\examples{
library(sp)
df <- data.frame(x = rnorm(10),
                 y = rnorm(10))
coordinates(df) <- ~x+y
G <- auto_basis(plane(),df,nres=1)
data.frame(G) # Print info on basis
G <- remove_basis(G,1:(nbasis(G)-1))
data.frame(G)
}
\seealso{
\code{\link{auto_basis}} for automatically constructing basis functions and \code{\link{show_basis}} for visualising basis functions.
}
