% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resize_image.R
\name{resize_image}
\alias{resize_image}
\title{Function to change image size (Funcao para mudar o tamanho da imagem)}
\usage{
resize_image(im, w=NULL, h=NULL,percentage=NULL,plot=FALSE)
}
\arguments{
\item{im}{:Este objeto deve conter uma imagem no formato do EBImage ou na
forma de uma matriz.}

\item{w}{: e o numero de linhas que pretende-se obter na imagem de saida.
Se houver o valor de h este valor e dispensavel, caso queira manter a
proporcionalidade.}

\item{h}{: e o numero de colunas que pretende-se obter na imagem de
saida.Se houver o valor de w este valor e dispensavel, caso queira manter a
proporcionalidade.}

\item{percentage}{: Desired percentage for image reduction (Porcentagem desejada para a reducao da imagem).}

\item{plot}{:Indica se sera apresentada (TRUE) ou nao (FALSE) (default) a
imagem editada}
}
\value{
Retorna uma imagem com o tamanho desejado.
}
\description{
Esta funcao permite mudar o tamanho de uma imagem, modificando o
  peso ocupado na memoria e em sua resolucao.
}
\examples{
\donttest{

#Carregar imagem de exemplo
im=read_image(example_image(1))
##mostrar imagem
plot_image(im)


##Diminuir a resolucao (tamanho da imagem)
im2=resize_image(im,w=1000,plot=TRUE)
im2b=resize_image(im,percentage = 10,plot=TRUE)
##Cortar Imagem
im3=crop_image(im2,w =200:750,h=100:650,plot = TRUE)

##Aumentar brilho
im4=edit_image(im3,brightness = 0.1)

#Aumentar contraste
im5=edit_image(im4,contrast = 1.2)

#Aumentar gamma
im6=edit_image(im5,gamma  = 1.1)


#Alterando brilho, contraste e gamma
imb=edit_image(im3,brightness = 0.1,contrast = 1.7,gamma  = 1.2)

#Mostrando ambas as imagens simultaneamente.
join_image(im3,imb)
}
}
\seealso{
\code{\link{crop_image}} , \code{\link{edit_image}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
