#' Patient Length of Stay
#'
#' @description Data used on June 16, 2020 Exam PA
#'
#' @docType data
#'
#' @usage patient_length_of_stay
#'
#' @format data.frame,  10000 observations of 13 variables:
#' \describe{
#'   \item{days}{Number of days between admission into and discharge from
#'         hospital. Integer 1 - 14.}
#'   \item{gender}{Patient gender. Male or Female.}
#'   \item{age}{Patient age (in 10-year age bands). [0, 10), [10, 20), ...,
#'         [90, 100)}
#'   \item{race}{patient race. AfricanAmerican, Asian, Caucasian, Hispanic,
#'         Other.}
#'   \item{weight}{Patient weight (in 25-pound weight bands). [0, 25), [25, 50),
#'         [175, 200)}
#'   \item{admit_type_id}{Identifier corresponding to the type of hospital
#'         admission. 1 = Emergency, 2 = Urgent, 3 = Elective,
#'         4 = Not Available.}
#'   \item{metformin}{Indicates whether upon admission, metformin was
#'         prescribed or there was a change in the dosage. Up = dosage was
#'         increased, Down = dosage was decreased, Steady = dosage did not
#'         change, No = drug was not prescribed.}
#'   \item{insulin}{Indicates whether upon admission, insulin was prescribed or
#'         there was a change in the dosage. Up = dosage was increased, Down =
#'         dosage was decreased, Steady = dosage did not change, No = drug was
#'         not prescribed.}
#'   \item{readmitted}{Indicates whether patient had been readmitted after an
#'         inpatient stay in the twelve months preceding the encounter.
#'         <30 = patient was readmitted in less than 30 days, >30 = patient was
#'         readmitted in more than 30 days, No = no record of readmission.}
#'   \item{num_procs}{Number of procedures performed in the twelve months
#'         preceding the encounter. Integer 0 - 6.}
#'   \item{num_meds}{Number of distinct medications administered in the twelve
#'         months preceding the encounter. Integer 1 - 67.}
#'   \item{num_ip}{Number of the inpatient visits of the patient in the twelve
#'         months preceding the encounter. Integer 0 -21.}
#'   \item{num_diags}{Number of diagnoses entered to the system in the twelve
#'         months preceding the encounter. Integer 1 - 16.}
#' }
#'
#' @keywords datasets
#'
#'
#'
"patient_length_of_stay"
