% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{report_cases}
\alias{report_cases}
\title{Report case counts by date of report}
\usage{
report_cases(
  case_estimates,
  case_forecast = NULL,
  delays,
  type = "sample",
  reporting_effect,
  CrIs = c(0.2, 0.5, 0.9)
)
}
\arguments{
\item{case_estimates}{A data.table of case estimates with the following
variables: date, sample, cases}

\item{case_forecast}{A data.table of case forecasts with the following
variables: date, sample, cases. If not supplied the default is not to
incorporate forecasts.}

\item{delays}{A call to \code{\link[=delay_opts]{delay_opts()}} defining delay distributions and
options. See the documentation of \code{\link[=delay_opts]{delay_opts()}} and the examples below for
details.}

\item{type}{Character string indicating the method to use to transform
counts. Supports either "sample"  which approximates sampling or "median"
would shift by the median of the distribution.}

\item{reporting_effect}{A \code{data.table} giving the weekly reporting effect
with the following variables: \code{sample} (must be the same as in \code{nowcast}),
\code{effect} (numeric scaling factor for each weekday),\code{day} (numeric 1 - 7
(1 = Monday and 7 = Sunday)). If not supplied then no weekly reporting
effect is assumed.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}
}
\value{
A list of \code{data.table}s. The first entry contains the following
variables \code{sample}, \code{date} and \code{cases} with the second being summarised
across samples.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Convolves latent infections to reported cases via an observation model.
Likely to be removed/replaced in later releases by functionality drawing on
the \code{stan} implementation.
}
\keyword{internal}
