% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_backcalc_data}
\alias{create_backcalc_data}
\title{Create Back Calculation Data}
\usage{
create_backcalc_data(backcalc = backcalc_opts)
}
\arguments{
\item{backcalc}{A list of options as generated by \code{backcalc_opts()} to define the
back calculation. Defaults to \code{backcalc_opts()}.}
}
\value{
A list of settings defining the Gaussian process
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}
Takes the output of \code{backcalc_opts()} and converts it into a list understood by \code{stan}.
}
\examples{
# define input data required
data <- list(
    t = 30,
    seeding_time = 7,
    horizon = 7)

# default gaussian process data     
create_gp_data(data = data)

# settings when no gaussian process is desired
create_gp_data(NULL, data)

# custom lengthscale
create_gp_data(gp_opts(ls_mean = 14), data)
}
\seealso{
backcalc_opts
}
