% Generated by roxygen2 (4.0.1): do not edit by hand
\name{summary.icm}
\alias{summary.icm}
\title{Summary Model Statistics}
\usage{
\method{summary}{icm}(object, at, digits = 3, ...)
}
\arguments{
\item{object}{an \code{EpiModel} object of class \code{icm}.}

\item{at}{time step for model statistics.}

\item{digits}{number of significant digits to print.}

\item{...}{additional summary function arguments.}
}
\description{
Extracts and prints model statistics simulated with \code{icm}.
}
\details{
Summary statistics for the main epidemiological outcomes (state and transition
size and prevalence) from an \code{icm} model. Time-specific summary measures
are provided, so it is necessary to input a time of interest.
}
\examples{
## Stochastic ICM SI model with 3 simulations
param <- param.icm(trans.rate = 0.2, act.rate = 1)
init <- init.icm(s.num = 500, i.num = 1)
control <- control.icm(type = "SI", nsteps = 50,
                       nsims = 5, verbose = FALSE)
mod <- icm(param, init, control)
summary(mod, at = 25)
summary(mod, at = 50)
}
\seealso{
\code{\link{icm}}
}
\keyword{extract}

