% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_incubestim_plot.R
\name{plot.incubestim}
\alias{plot.incubestim}
\title{Plot the estimated incubation distribution}
\usage{
\method{plot}{incubestim}(x, type = c("pdf", "cdf", "incubwin"), ...)
}
\arguments{
\item{x}{An object of class \code{incubestim}.}

\item{type}{The type of plot. Default is "pdf" for the plot of the density
function. Setting it to "cdf" returns the cumulative distribution function
and "incubwin" gives a bar plot showing the width of the incubation window.}

\item{...}{Further arguments to be passed to plot.}
}
\value{
\itemize{
 \item{The probability density function of the estimated incubation period with
  95\% credible envelope.}
 \item{The cumulative distribution function of the estimated incubation period with
  95\% credible envelope.}
\item{A bar plot showing the width of the incubation windows.}
}
}
\description{
This routine can be used to plot the estimated incubation
distribution based on an object of class \code{incubestim}.
}
\examples{
set.seed(123)
simdat <- incubsim(n = 30, tmax = 20) # Simulate incubation data
data <- simdat$Dobsincub              # Incubation bounds
incubfit <- estimIncub(x = data, niter = 500, tmax = 20, verbose = TRUE)
plot(incubfit)

}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}
}
