% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotExpectedType1Error}
\alias{plotExpectedType1Error}
\title{Plot the expected type 1 error as a function of standard error}
\usage{
plotExpectedType1Error(logRrNegatives, seLogRrNegatives, seLogRrPositives,
  alpha = 0.05, null = NULL, xLabel = "Relative risk", title,
  showCis = FALSE, showEffectSizes = FALSE, fileName = NULL)
}
\arguments{
\item{logRrNegatives}{A numeric vector of effect estimates of the negative controls on the log
scale.}

\item{seLogRrNegatives}{The standard error of the log of the effect estimates of the negative
controls.}

\item{seLogRrPositives}{The standard error of the log of the effect estimates of the positive
controls.}

\item{alpha}{The alpha (nominal type 1 error) to be used.}

\item{null}{An object representing the fitted null distribution as created by the
\code{fitNull} function. If not provided, a null will be fitted before
plotting.}

\item{xLabel}{If showing effect sizes, what label should be used for the effect size axis?}

\item{title}{Optional: the main title for the plot}

\item{showCis}{Show 95 percent credible intervals for the expected type 1 error.}

\item{showEffectSizes}{Show the expected effect sizes alongside the expected type 1 error?}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'.
See the function \code{ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A Ggplot object. Use the \code{ggsave} function to save to file.
}
\description{
\code{plotExpectedType1Error} creates a plot showing the expected type 1 error as a function of standard error.
}
\details{
Creates a plot with the standard error on the x-axis and the expected type 1 error on the y-axis. The 
red line indicates the expected type 1 error  given the estimated empirical null distribution if no 
calibration is performed. The dashed line indicated the nominal expected type 1 error rate, assuming 
the theoretical null distribution.

If standard errors are provided for non-negative estimates these will be plotted on the red line as
yellow diamonds.
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
positive <- sccs[sccs$groundTruth == 1, ]
plotExpectedType1Error(negatives$logRr, negatives$seLogRr, positive$seLogRr)

}
