% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotErrorModel}
\alias{plotErrorModel}
\title{Plot the systematic error model}
\usage{
plotErrorModel(logRr, seLogRr, trueLogRr, title, fileName = NULL)
}
\arguments{
\item{logRr}{A numeric vector of effect estimates on the log scale.}

\item{seLogRr}{The standard error of the log of the effect estimates. Hint: often the
standard error = (log(<lower bound 95 percent confidence interval>) -
log(<effect estimate>))/qnorm(0.025).}

\item{trueLogRr}{The true log relative risk.}

\item{title}{Optional: the main title for the plot}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'.
See the function \code{ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A Ggplot object. Use the \code{ggsave} function to save to file.
}
\description{
\code{plotErrorModel} creates a plot showing the systematic error model.
}
\details{
Creates a plot with the true effect size on the x-axis, and the mean plus and minus the standard 
deviation shown on the y-axis. Also shown are simple error models fitted at each true relative 
risk in the input.
}
\examples{
data <- simulateControls(n = 50 * 3, mean = 0.25, sd = 0.25, trueLogRr = log(c(1, 2, 4)))
plotErrorModel(data$logRr, data$seLogRr, data$trueLogRr)
}
