% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_above_treeline.R
\name{classify_above_treeline}
\alias{classify_above_treeline}
\title{Classify points as above or below the treeline}
\usage{
classify_above_treeline(coords, gstRaster, gslRaster, gstTreshold = 6.4,
                              gslTreshold = 94)
}
\arguments{
\item{coords}{Data frame representing coordinates (WGS 84) to be classified.
The first column must contain the longitude, the second the latitude, both in decimal degrees.
The values must be of the data type "numeric" and finite.
A data frame can be generated by using the function \code{generate_grid}.}

\item{gstRaster}{Climatic raster that contains the growing season temperature. Data type "SpatRaster".}

\item{gslRaster}{Climatic raster that contains the growing season length. Data type "SpatRaster".}

\item{gstTreshold}{Growing season temperature threshold for tree growth (in degree Celsius). One value, data type "numeric" and finite.}

\item{gslTreshold}{Growing season length threshold for tree growth (days). One value, data type "integer" and finite.}
}
\value{
A data frame containing: longitude, latitude,
growing season temperature, growing season length, and a boolean.
The boolean indicates if the point is above the treeline.
}
\description{
Calculates if the points (from the input data frame \code{coords}) are above the treeline (\code{TRUE}) or not (\code{FALSE}).
This is achieved by using climate layers for growing season length and growing season temperature. For each coordinate a value from both
rasters is extracted and added to the input data frame. Then points are classified, the default thresholds and the treeline definition
is based on Paulsen and Körner, Alp. Bot. 124: 1-12 (2014). Classification (as boolean) is also added to the output.
}
\examples{
#Get raster layer from CHELSA
gstURL <- paste0("https://os.zhdk.cloud.switch.ch/envicloud/chelsa/chelsa_V2/",
                 "GLOBAL/climatologies/1981-2010/bio/CHELSA_gst_1981-2010_V.2.1.tif")
gslURL <- paste0("https://os.zhdk.cloud.switch.ch/envicloud/chelsa/chelsa_V2/",
                 "GLOBAL/climatologies/1981-2010/bio/CHELSA_gsl_1981-2010_V.2.1.tif")
\donttest{
gst <- terra::rast(gstURL, vsi = TRUE)
gsl <- terra::rast(gslURL, vsi = TRUE)

#Classify a single point
point <- data.frame("lon" = 8.65, "lat" = 46.87)
classify_above_treeline(coords = point, gstRaster = gst, gslRaster = gsl,
                        gstTreshold = 6.4, gslTreshold = 94)

#Classify a dummy data frame
longitude <- rep(8.53, 11)
latitude <- seq(46.8, 46.9, 0.01)
temp <- data.frame(longitude, latitude)
classify_above_treeline(coords = temp, gstRaster = gst, gslRaster = gsl,
                        gstTreshold = 6.4, gslTreshold = 94)
}
}
\author{
Livio Bätscher, Jurriaan M. de Vos
}
