% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportar.R
\name{exportar}
\alias{exportar}
\title{Exportacao de resultado}
\usage{
exportar(resultado)
}
\arguments{
\item{resultado}{Lista resultante da função \code{\link{calcular.elasticidades}} ou
ou da função \code{\link{decompor.todos}} com um conjunto de elasticidades calculadas.}
}
\value{
Data frame no formato correto para exportação para o Excel.
}
\description{
Função que formata os dados para um padrão de exportação.
}
\examples{
\dontrun{data(Exemplo)}
\donttest{resultado <- calcular.elasticidades(Exemplo$receitas, Exemplo$Hpib, Exemplo$Hpet, fim=c(2015,4))}

\donttest{resultado.exportacao <- exportar(resultado)}
\donttest{write.csv2(resultado.exportacao, "/tmp/dados.csv")} #Escreve resultados em arquivo CSV.
}
\seealso{
\code{\link{decompor.todos}}
\code{\link{calcular.elasticidades}}
\code{\link{Exemplo}}
}
