% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectliter.R
\name{effectLite}
\alias{effectLite}
\title{Estimate average and conditional effects}
\usage{
effectLite(
  y,
  x,
  k = NULL,
  z = NULL,
  data,
  method = "sem",
  control = "default",
  measurement = character(),
  fixed.cell = "default",
  fixed.z = "default",
  missing = "default",
  se = "default",
  syntax.only = FALSE,
  interactions = "all",
  homoscedasticity = "default",
  test.stat = "default",
  propscore = NULL,
  ids = ~0,
  weights = NULL,
  add = character(),
  ...
)
}
\arguments{
\item{y}{Dependent variable (character string). Can be the name of a manifest variable or of a latent variable.}

\item{x}{Treatment variable (character string) treated as categorical variable.}

\item{k}{Vector of manifest variables treated as categorical covariates (character vector).}

\item{z}{Vector of continuous covariates (character vector). Names of both manifest and latent variables are allowed.}

\item{data}{A data frame.}

\item{method}{Can be one of \code{c("sem","lm")} and indicates which function is used to fit the model.}

\item{control}{Value of \code{x} that is used as control group. If "default", takes the first entry of \code{as.factor(x)}.}

\item{measurement}{Measurement model. The measurement model is lavaan syntax (character string), that will be appended before the automatically generated lavaan input. It can be used to specify a measurement for a latent outcome variable and/or latent covariates. See also the example and \code{\link[EffectLiteR]{generateMeasurementModel}}.}

\item{fixed.cell}{logical. If \code{FALSE}, the group sizes are treated as stochastic rather than fixed. The default setting for \code{method="sem"} is \code{FALSE} and the default setting for \code{method="lm"} is \code{TRUE}.}

\item{fixed.z}{logical. If \code{FALSE}, the continuous covariates are treated as stochastic rather than fixed. The default setting for \code{method="sem"} is \code{FALSE} and the default setting for \code{method="lm"} is \code{TRUE}.}

\item{missing}{Missing data handling. Will be passed on to \code{\link[lavaan]{sem}} or ignored for \code{method="lm"}.}

\item{se}{Type of standard errors. Will be 
passed on to \code{\link[lavaan]{sem}} or ignored for \code{method="lm"}.}

\item{syntax.only}{logical. If \code{TRUE}, only syntax is returned and the model 
will not be estimated.}

\item{interactions}{character. Indicates the type of interaction. Can be one of \code{"all"} (all interactions), \code{"2-way"} (only two-way interactions), \code{"X:K,X:Z"} (only X:K and X:Z interactions), \code{"X:K"} (only X:K interactions), \code{"X:Z"} (only X:Z interactions), \code{"none"} (no treatment by covariate interactions, but potentially interactions between categorical and continuous covariates), or \code{"no"} (no interactions at all).}

\item{homoscedasticity}{logical. If \code{TRUE}, residual variances of the dependent variable are assumed to be homogeneous across cells. The default setting for \code{method="sem"} is \code{FALSE} and the default setting for \code{method="lm"} is \code{TRUE}.}

\item{test.stat}{character. Can be one of \code{c("default","Chisq","Ftest")} and indicates the statistic used for the hypothesis tests. The tests are either based on the large sample Chi-Squared statistic (Wald tests) or the finite sample F statistic with approximate F distribution.  The default setting for \code{method="sem"} is \code{"Chisq"} and the default setting for \code{method="lm"} is \code{"Ftest"}.}

\item{propscore}{Vector of covariates (character vector) that will be used to compute (multiple) propensity scores based on a multinomial regression without interactions. Alternatively, the user can specify a formula with the treatment variable as dependent variable for more control over the propensity score model.}

\item{ids}{Formula specifying cluster ID variables. Will be passed on to \code{lavaan.survey} if \code{lavaan.survey} is installed. If not, the \code{cluster} argument in \code{\link[lavaan]{sem}} will be used. See \code{\link[survey]{svydesign}} for details.}

\item{weights}{Formula to specify sampling weights. Currently only one weight variable is supported. Will be passed on to \code{lavaan.survey} if \code{lavaan.survey} is installed. If not, the \code{sampling.weights} argument in \code{\link[lavaan]{sem}} will be used. See \code{svydesign} for details. Note: Only use weights if you know what you are doing. For example, some conditional treatment effects may require different weights than average effects.}

\item{add}{Character string that will be pasted at the end of the generated lavaan syntax. Can for example be used to add additional (in-) equality constraints or to compute user-defined conditional effects.}

\item{...}{Further arguments passed to \code{\link[lavaan]{sem}}.}
}
\value{
Object of class effectlite.
}
\description{
This function is the main function of the package and can be used to estimate
average and conditional effects of a treatment variable on an outcome variable,
taking into account any number of continuous and categorical covariates.
It automatically generates lavaan syntax for a multi-group structural equation
model, runs the model using lavaan, and extracts various average and conditional
effects of interest.
}
\examples{
## Example with one categorical covariate
m1 <- effectLite(y="y", x="x", k="z", control="0", data=nonortho)
print(m1) 

## Example with one categorical and one continuous covariate
m1 <- effectLite(y="dv", x="x", k=c("k1"), z=c("z1"), control="control", data=example01)
print(m1)

## Example with latent outcome and latent covariate
measurement <- '
eta2 =~ 1*CPM12 + 1*CPM22
eta1 =~ 1*CPM11 + 1*CPM21
CPM11 + CPM12 ~ 0*1
CPM21 ~ c(m,m)*1
CPM22 ~ c(p,p)*1'

m1 <- effectLite(y="eta2", x="x", z=c("eta1"), control="0", 
                 measurement=measurement, data=example02lv)
print(m1)

\dontrun{
## Example with cluster variable and sampling weights
m1 <- effectLite(y="y", x="x", z="z", fixed.cell=TRUE, control="0", 
                    syntax.only=F, data=example_multilevel, 
                    ids=~cid, weights=~weights)
print(m1)
}
}
\references{
Mayer, A., Dietzfelbinger, L., Rosseel, Y. & Steyer, R. (2016). The EffectLiteR approach for analyzing average and conditional effects. Multivariate Behavioral Research, 51, 374-391.
}
