% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmm.R
\name{buildRMM}
\alias{buildRMM}
\title{Build metadata object from ENMeval results}
\usage{
buildRMM(e, envs, rmm = NULL)
}
\arguments{
\item{e}{ENMevaluation object}

\item{envs}{RasterStack: environmental predictor variables used in analysis; needed to pull information on the predictor variables
not included in the ENMevaluation object}

\item{rmm}{rangeModelMetadata object: if included, fields are appended to this RMM object as opposed to returning a new RMM object}
}
\description{
Builds a \code{rangeModelMetadata} object from the output of \code{ENMevaluate}.
See Merow \emph{et al.} (2019) for more details on the nature of the metadata and the \code{rangeModelMetadata} package.
To improve reproducibility of the study, this metadata object can be used as supplemental information for a manuscript, shared with collaborators, etc.
}
\references{
Merow, C., Maitner, B. S., Owens, H. L., Kass, J. M., Enquist, B. J., Jetz, W., & Guralnick, R. (2019). Species' range model metadata standards: RMMS. \emph{Global Ecology and Biogeography}, \bold{28}: 1912-1924. \doi{10.1111/geb.12993}
}
