% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_single.R
\name{get_prior_single}
\alias{get_prior_single}
\title{Prior specification or prior sampling for single subject estimation}
\usage{
get_prior_single(
  prior = NULL,
  n_pars = NULL,
  sample = TRUE,
  N = 1e+05,
  selection = "alpha",
  design = NULL,
  map = FALSE
)
}
\arguments{
\item{prior}{A named list containing the prior mean (\code{theta_mu_mean}) and
variance (\code{theta_mu_var}). If \code{NULL}, the default prior is used.}

\item{n_pars}{Often inferred from the design, but if \code{design = NULL}, \code{n_pars}
will be used to determine the size of prior.}

\item{sample}{Boolean, defaults to \code{TRUE}, sample from the prior or simply
return the prior specifications?}

\item{N}{How many samples to draw from the prior, the default is 1e5}

\item{selection}{Character. If \code{sample = TRUE}, what prior to sample from. Options: \code{"alpha"}.}

\item{design}{The design obtained from \code{design()}, required when \code{map = TRUE}}

\item{map}{Boolean, defaults to \code{TRUE}. If \code{sample = TRUE}, the implied prior is sampled.
This includes back-transformations for naturally bounded parameters such as
the non-decision time and an inverse mapping from the design matrix back to the
cells of the design. If \code{FALSE}, the transformed, unmapped, parameters are used.
Note that \code{map} does not affect the prior used in the sampling process.}
}
\value{
A list with a single entry named \code{"alpha"} and samples from the prior (if \code{sample = TRUE}) or else a prior object
}
\description{
With this type of estimation, one or multiple subjects are
estimated independently, without any hierarchical constraint.
}
\details{
To specify a (multivariate normal) prior, \code{prior$theta_mu_mean} and \code{prior$theta_mu_var} an entry
is needed for each parameter.
}
\examples{
# First define a design for the model
design_DDMaE <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# Now get the default prior
prior <- get_prior_single(design = design_DDMaE, sample = FALSE)
# We can change values in the default prior or use `prior`
# Then we can get samples from this prior e.g.
samples <- get_prior_single(prior = prior, design = design_DDMaE,
  sample = TRUE, selection = "alpha")

}
