% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_factor.R
\name{get_prior_factor}
\alias{get_prior_factor}
\title{Prior specification and prior sampling for factor estimation}
\usage{
get_prior_factor(
  prior = NULL,
  n_pars = NULL,
  sample = TRUE,
  N = 1e+05,
  selection = "mu",
  design = NULL,
  Lambda_mat = NULL,
  n_factors = NULL
)
}
\arguments{
\item{prior}{A named list that can contain the prior mean (\code{theta_mu_mean}) and
variance (\code{theta_mu_var}) on the group-level mean; the variance of the loadings (\code{theta_lambda_var});
shape and rate of the factor variances (\code{ap} and \code{bp}) and shape and rate of the residual variances
(\code{as} and \code{bs}). For \code{NULL} entries, the default prior is is used.}

\item{n_pars}{Often inferred from the design, but if \code{design = NULL}, \code{n_pars}
will be used to determine the size of prior.}

\item{sample}{Whether to sample from the prior or to simply return the prior. Default is TRUE,}

\item{N}{How many samples to draw from the prior, the default is 1e5}

\item{selection}{Character. If \code{sample = TRUE}, what priors to sample from.}

\item{design}{The design obtained from \code{design()}, required when \code{map = TRUE}}

\item{Lambda_mat}{The loadings constraint matrix.}

\item{n_factors}{Integer. The number of factors.}
}
\value{
A list with a single entry of type of samples from the prior (if \code{sample = TRUE}) or else a prior object
}
\description{
To get the default priors for a given design: \code{get_prior_factor(design = design, sample = FALSE)}
}
\details{
For details see Ghosh, J., & Dunson, D. B. (2009).
Default prior distributions and efficient posterior computation in Bayesian factor analysis.
\emph{Journal of Computational and Graphical Statistics}, 18, 306-320. or
Stevenson, N., Innes, R. J., Gronau, Q. F., Miletic, S., Heathcote, A., PhD,
Forstmann, B., & Brown, S. (2024). Using group level factor models to resolve
high dimensionality in model-based sampling. https://doi.org/10.31234/osf.io/pn3wv.

Note that if \code{sample = FALSE}, prior$theta_mu_invar (the inverse of the prior covariance matrix on the group-level mean) is returned,
which is only used for computational efficiency
}
\examples{
# First define a design for the model
design_DDMaE <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# Now get the default prior
prior <- get_prior_factor(design = design_DDMaE, sample = FALSE, n_factors = 3)
# We can change values in the default prior or use `prior`
# Then we can get samples from this prior e.g.
samples <- get_prior_factor(prior = prior, design = design_DDMaE,
  sample = TRUE, selection = "mu", n_factors = 3)

}
