% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAtools_IO.R
\name{annotate.plate}
\alias{annotate.plate}
\title{S3 method to annotate ELISA plate}
\usage{
annotate.plate(sample.id, sample.prefix, sample.suffix, num.sample,
  num.std = 8, byRow.sample = TRUE, byRow.replicates = TRUE,
  replicates.sample = 3, replicates.std = 3, rows, columns,
  std.first = TRUE)
}
\arguments{
\item{sample.id}{character vector to specify the names/ids of
the samples on the plate. Note, standard/calibration sample
ids/names is fixed to be "s1","s2", etc, which are specified
by the software and users don't need to privide.}

\item{sample.prefix}{characters will be added to the beginning of sample names}

\item{sample.suffix}{characters will be added to the end of sample names}

\item{num.sample}{numeric number of samples to write}

\item{num.std}{numeric number of standards}

\item{byRow.sample}{boolean indicate whether to write sample names 
horizontally by row (TURE) or vertically by column (FALSE)}

\item{byRow.replicates}{boolean indicate whether to write sample replicates 
horizontally by row (TURE) or vertically by column (FALSE)}

\item{replicates.sample}{numeric number of replicates for each sample}

\item{replicates.std}{numeric number of replicates for each standards}

\item{rows}{numeric vector to specify which rows to be included in the annotation}

\item{columns}{numeric vector to specify which columns 
to be included in the annotation}

\item{std.first}{boolean to indicate whether to write standards first or
the samples first.}
}
\value{
a dataframe holding the annotations for the plate.
}
\description{
to write annotations for an ELISA plate as
   an input to guide the functions to read OD values
}
\details{
Based on the input to quickly write the annotations
 for ELISA plate. The output is in a 96-well format and 
will be used to giude the reading of OD plates. This way
only a nxm dataframe can be used. To write non-regular
annotation, you have to do it mannually.
}
