% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynEGA.ind.pop.R
\name{dynEGA.ind.pop}
\alias{dynEGA.ind.pop}
\title{Dynamic EGA}
\usage{
dynEGA.ind.pop(
  data,
  n.embed,
  tau = 1,
  delta = 1,
  id = NULL,
  use.derivatives = 1,
  model = c("glasso", "TMFG"),
  model.args = list(),
  algorithm = c("walktrap", "leiden", "louvain"),
  algorithm.args = list(),
  corr = c("cor_auto", "pearson", "spearman"),
  uni.method = c("expand", "LE", "louvain"),
  ncores,
  progress = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame with the variables to be used in the analysis.
The data frame should be in a long format (i.e. observations for the
same individual (for example, individual 1) are placed in order,
from time 1 to time t, followed by the observations from individual 2, also
ordered from time 1 to time t.)}

\item{n.embed}{Integer.
Number of embedded dimensions (the number of observations to be used in the \code{\link[EGAnet]{Embed}} function). For example,
an \code{n.embed = 5} will use five consecutive observations to estimate a single derivative.}

\item{tau}{Integer.
Number of observations to offset successive embeddings in the \code{\link[EGAnet]{Embed}} function. A tau of one uses adjacent observations.
Default is \code{tau = 1}.}

\item{delta}{Integer.
The time between successive observations in the time series.
Default is \code{delta = 1}.}

\item{id}{Numeric.
Number of the column identifying each individual.}

\item{use.derivatives}{Integer.
The order of the derivative to be used in the EGA procedure. Default to 1.}

\item{model}{Character.
A string indicating the method to use. Defaults to \code{glasso}.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter.
This is the default method}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{model.args}{List.
A list of additional arguments for \code{\link[EGAnet]{EBICglasso.qgraph}}
or \code{\link[EGAnet]{TMFG}}}

\item{algorithm}{A string indicating the algorithm to use or a function from \code{\link{igraph}}
Defaults to \code{"walktrap"}.
Current options are:

\itemize{

\item{\strong{\code{walktrap}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_walktrap}}}

\item{\strong{\code{leiden}}}
{Computes the Leiden algorithm using \code{\link[igraph]{cluster_leiden}}.
Defaults to \code{objective_function = "modularity"}}

\item{\strong{\code{louvain}}}
{Computes the Louvain algorithm using \code{\link[igraph]{cluster_louvain}}}

}}

\item{algorithm.args}{List.
A list of additional arguments for \code{\link[igraph]{cluster_walktrap}}, \code{\link[igraph]{cluster_louvain}},
or some other community detection algorithm function (see examples)}

\item{corr}{Type of correlation matrix to compute. The default uses \code{\link[qgraph]{cor_auto}}.
Current options are:

\itemize{

\item{\strong{\code{cor_auto}}}
{Computes the correlation matrix using the \code{\link[qgraph]{cor_auto}} function from
\code{\link[qgraph]{qgraph}}}.

\item{\strong{\code{pearson}}}
{Computes Pearson's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.

\item{\strong{\code{spearman}}}
{Computes Spearman's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.
}}

\item{uni.method}{Character.
What unidimensionality method should be used? 
Defaults to \code{"LE"}.
Current options are:

\itemize{

\item{\strong{\code{expand}}}
{Expands the correlation matrix with four variables correlated .50.
If number of dimension returns 2 or less in check, then the data 
are unidimensional; otherwise, regular EGA with no matrix
expansion is used. This is the method used in the Golino et al. (2020)
\emph{Psychological Methods} simulation.}

\item{\strong{\code{LE}}}
{Applies the Leading Eigenvalue algorithm (\code{\link[igraph]{cluster_leading_eigen}})
on the empirical correlation matrix. If the number of dimensions is 1,
then the Leading Eigenvalue solution is used; otherwise, regular EGA
is used. This is the final method used in the Christensen, Garrido,
and Golino (2021) simulation.}

\item{\strong{\code{louvain}}}
{Applies the Louvain algorithm (\code{\link[igraph]{cluster_louvain}})
on the empirical correlation matrix using a resolution parameter = 0.95.
If the number of dimensions is 1, then the Louvain solution is used; otherwise,
regular EGA is used. This method was validated in the Christensen (2022) simulation.}

}}

\item{ncores}{Numeric.
Number of cores to use in computing results.
Defaults to \code{parallel::detectCores() / 2} or half of your
computer's processing power.
Set to \code{1} to not use parallel computing.
Recommended to use maximum number of cores minus one

If you're unsure how many cores your computer has,
then use the following code: \code{parallel::detectCores()}}

\item{progress}{Boolean.
Should progress be displayed?
Defaults to \code{TRUE}.
For Windows, \code{FALSE} is about 2x faster}

\item{...}{Additional arguments.
Used for deprecated arguments from previous versions of \code{\link{EGA}}}
}
\description{
DynEGA estimates dynamic factors in multivariate time series (i.e. longitudinal data, panel data, intensive longitudinal data) at multiple
time scales, in different levels of analysis: individuals (intraindividual structure) and population (structure of the population).
Exploratory graph analysis is applied in the derivatives estimated using generalized local linear approximation (\code{\link[EGAnet]{glla}}). Instead of estimating factors by modeling how variables are covarying, as in traditional
EGA, dynEGA is a dynamic model that estimates the factor structure by modeling how variables are changing together.
GLLA is a filtering method for estimating derivatives from data that uses time delay embedding and a variant of Savitzky-Golay filtering to accomplish the task.
}
\examples{
# Obtain data
sim.dynEGA <- sim.dynEGA # bypasses CRAN checks

\dontrun{
# Dynamic EGA individual and population structure
dyn.ega1 <- dynEGA.ind.pop(
  data = sim.dynEGA, n.embed = 5, tau = 1,
  delta = 1, id = 25, use.derivatives = 1,
  ncores = 2, corr = "pearson"
)}

}
\author{
Hudson Golino <hfg9s at virginia.edu>
}
