% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mctest.ergoInfo.R
\name{mctest.ergoInfo}
\alias{mctest.ergoInfo}
\title{Monte-Carlo Test for the Ergodicity Information Index}
\usage{
mctest.ergoInfo(
  iter,
  N,
  EII,
  use,
  variab,
  timep,
  nfact,
  error,
  dfm,
  loadings,
  autoreg,
  crossreg,
  var.shock,
  cov.shock,
  embed,
  tau,
  delta,
  derivatives,
  model,
  model.args = list(),
  algorithm = c("walktrap", "louvain"),
  algorithm.args = list(),
  corr,
  ncores,
  ...
)
}
\arguments{
\item{iter}{Numeric integer.
Number of random samples to generate in the Monte-Carlo simulation.
At least \code{500} is recommended}

\item{N}{Numeric integer.
Number of individuals to simulate data from, using the \code{\link[EGAnet]{simDFM}} function.}

\item{EII}{Numeric.
Empirical Ergodicity Information Index obtained via the \code{\link[EGAnet]{ergoInfo}} function.}

\item{use}{Character.
A string indicating what network element will be used to compute the algorithm complexity in the \code{\link[EGAnet]{ergoInfo}} function,
the list of edges or the weights of the network.
Defaults to \code{use = "edge.list"}.
Current options are:

\itemize{

\item{\strong{\code{edge.list}}}
{Calculates the algorithm complexity using the list of edges.}

\item{\strong{\code{weights}}}
{Calculates the algorithm complexity using the weights of the network.}
}}

\item{variab}{Number of variables per factor.}

\item{timep}{Number of time points.}

\item{nfact}{Number of factors.}

\item{error}{Value to be used to construct a diagonal matrix Q. This matrix is p x p covariance matrix Q that will
generate random errors following a multivariate normal distribution with mean zeros.
The value provided is squared before constructing Q.}

\item{dfm}{A string indicating the dynamical factor model to use. Defaults to \code{"DAFS"}.
Current options are:

\itemize{

\item{\strong{\code{DAFS}}}
{Simulates data using the direct autoregressive factor score model.
This is the default method}

\item{\strong{\code{RandomWalk}}}
{Simulates data using a dynamic factor model with random walk factor scores.}
}}

\item{loadings}{Magnitude of the loadings.}

\item{autoreg}{Magnitude of the autoregression coefficients.
Default is \code{"autoreg = 0.8"}.}

\item{crossreg}{Magnitude of the cross-regression coefficients.
Default is \code{"crossreg = 0.1"}.}

\item{var.shock}{Magnitude of the random shock variance.
Default is \code{"var.shock = 0.18"}.}

\item{cov.shock}{Magnitude of the random shock covariance
Default is \code{"cov.shock = 0.36"}.}

\item{embed}{Integer.
Number of embedded dimensions (the number of observations to be used in the \code{\link[EGAnet]{Embed}} function). For example,
an \code{"embed = 5"} will use five observations to estimate a single derivative. Defaults to \code{embed = 5}.}

\item{tau}{Integer.
Number of observations to offset successive embeddings in the \code{\link[EGAnet]{Embed}} function. A tau of one uses adjacent observations.
Default is \code{"tau = 1"}.}

\item{delta}{Integer.
The time between successive observations in the time series.
Default is \code{"delta = 1"}.}

\item{derivatives}{Integer.
The order of the derivative to be used in the EGA procedure. Default to 1.}

\item{model}{Character.
A string indicating the method to use. Defaults to \code{glasso}.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter.
This is the default method}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{model.args}{List.
A list of additional arguments for \code{\link[EGAnet]{EBICglasso.qgraph}}
or \code{\link[NetworkToolbox]{TMFG}}}

\item{algorithm}{A string indicating the algorithm to use or a function from \code{\link{igraph}}

Current options are:

\itemize{

\item{\strong{\code{walktrap}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_walktrap}}}

\item{\strong{\code{louvain}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_louvain}}}

}}

\item{algorithm.args}{List.
A list of additional arguments for \code{\link[igraph]{cluster_walktrap}}, \code{\link[igraph]{cluster_louvain}},
or some other community detection algorithm function (see examples)}

\item{corr}{Type of correlation matrix to compute. The default uses \code{\link[qgraph]{cor_auto}}.
Current options are:

\itemize{

\item{\strong{\code{cor_auto}}}
{Computes the correlation matrix using the \code{\link[qgraph]{cor_auto}} function from
\code{\link[qgraph]{qgraph}}}.

\item{\strong{\code{pearson}}}
{Computes Pearson's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.

\item{\strong{\code{spearman}}}
{Computes Spearman's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.
}}

\item{ncores}{Numeric.
Number of cores to use in computing results.
Defaults to \code{parallel::detectCores() / 2} or half of your
computer's processing power.
Set to \code{1} to not use parallel computing.
Recommended to use maximum number of cores minus one

If you're unsure how many cores your computer has,
then use the following code: \code{parallel::detectCores()}}

\item{...}{Additional arguments.
Used for deprecated arguments from previous versions of \code{\link{EGA}}}
}
\value{
Returns a list containing:

\item{mc.ergoInfo}{The values of the Ergodicity Information Index obtained in the Monte-Carlo Simulation}

\item{p.value.twosided}{The p-value of the Monte-Carlo test for the Ergodicity Information Index.
The null hypothesis is that the empirical Ergodicity Information index is equal to the expected value of the EII if the all individuals
had similar latent structures.}

\item{effect}{Indicates wheter the empirical EII is greater or less then the Monte-Carlo obtained EII.}

\item{plot.dist}{Histogram of the bootstrapped ergodicity information index}
}
\description{
Computes a Monte-Carlo Test for the Ergodicity Information Index, comparing the
empirical Ergodicity Information index to values obtained in a Monte-Carlo simulation in which all individuals
have a similar latent structure. The p-values in the Monte-Carlo test can be calculated as \code{(sum(EII>=MC.EII)+1)/(iter+1)} and as
\code{(sum(EII<=MC.EII)+1)/(iter+1)}, where EII is the empirical Ergodicity Information Index, MC.EII is the values of the Ergodicity Information Index obtained
in the simulation, and \code{iter} is the number of random samples generated in the simulation. The two-sided p-value is computed as two times the lowest p-value. In the Monte-Carlo Test for the Ergodicity Information Index,
the null hypothesis is that the empirical value of EII is equal to the Monte-Carlo value of EII obtained in multiple individuals with a similar latent structure.
Small values of p indicate that is very unlikely to obtain an EII as large as the one obtained in the empirical sample if the null hypothesis is true, thus there is convincing evidence that the empirical Ergodicity Information Index is
different than it could be expected if all individuals had a similar latent structure, conditioned on the parameters used to simulate the data.
}
\examples{

\dontrun{
\donttest{
dyn1 <- dynEGA.ind.pop(data = sim.dynEGA, n.embed = 5, tau = 1,
                      delta = 1, id = 21, group = 22, use.derivatives = 1,
                    model = "glasso", ncores = 2, corr = "pearson")

eii1 <- ergoInfo(data = dyn1)$EII

dist.ergoinfo <- mctest.ergoInfo(iter = 10, N = 10, EII = eii1,
variab = 4,
timep = 100, nfact = 2, error = 0.05, dfm = "DAFS", loadings = 0.55, autoreg = 0.8,
crossreg = 0.1, var.shock = 0.18, cov.shock = 0.36, embed = 5, tau=1, delta=1, derivatives=1,
model = "glasso", ncores = 2, corr = "pearson")
}}

}
\author{
Hudson Golino <hfg9s at virginia.edu>
}
