% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemConfirm.R
\name{itemConfirm}
\alias{itemConfirm}
\title{Replicability of Items from EGA}
\usage{
itemConfirm(bootega.obj, confirm, item.rep = 0.1, plot.ic = TRUE)
}
\arguments{
\item{bootega.obj}{A \code{\link{bootEGA}} object}

\item{confirm}{A vector with community numbers or labels for each item}

\item{item.rep}{A value for lowest likelihood allowed in \code{item.likelihood} output.
Removes noise from table to allow for easier interpretation.
Defaults to .10}

\item{plot.ic}{Should the plot be produced?
Defaults to TRUE}
}
\value{
Returns a list containing:

\item{item.confirm}{The proporton of times each item replicated
within the defined dimension}

\item{item.likelihood}{The proportion of times each item replicated
within each possible dimension. Dimensions greater than the maximum
number used in the \code{confirm} argument are labeled based on the
largest remaining components after the dimensions used to confirm.}

\item{wc}{A matrix containing the community membership values for
each bootstrapped sample. The values correspond to the values input
for the \code{confrim} argument.}
}
\description{
Based on the \code{\link{bootEGA}} results, this function
computes and plots the number of times an item (variable) is estimated
in the same factor/dimension as originaly estimated by EGA. The output
also each item's likelihood (i.e., proprotion of bootstraps that it
appeared in) for every possible dimension (defined by the maximum number
of dimensions across the bootstrap samples).
}
\examples{
\donttest{
ega.wmt <- EGA(data = wmt2[,7:24], model = "glasso")

boot.wmt <- bootEGA(data = wmt2[,7:24], n = 100, typicalStructure = TRUE,
plot.typicalStructure = TRUE, model = "glasso",
type = "parametric", ncores = 4)

itemConfirm(boot.wmt, confirm = ega.wmt$wc)
}

}
\references{
Danon, L., Diaz-Guilera, A., Duch, J., & Arenas, A. (2005).
Comparing community structure identification.
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{9}, P09008.
<doi:10.1088/1742-5468/2005/09/P09008>
}
\seealso{
\code{\link{EGA}} to estimate the number of dimensions of an instrument using EGA and \code{\link{CFA}} to
verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
